package examples.webservices.rpc.weatherEJB;

import java.rmi.RemoteException;
import javax.ejb.EJBObject;

/**
 * The methods in this interface are the public face of WeatherBean.
 * The signatures of the methods are identical to those of the EJBean, except
 * that these methods throw a java.rmi.RemoteException.
 * Note that the EJBean does not implement this interface. The corresponding
 * code-generated EJBObject, WeatherBean, implements this interface and
 * delegates to the bean.
 *
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */
public interface Weather extends EJBObject {

  /**
   * Gets the temperature of a given ZipCode.
   *
   * @param ZipCode           String Stock symbol
   * @return                  double Temperature
   * @exception               RemoteException if there is
   *                          a communications or systems failure
   */
  public float getTemp(String ZipCode) throws RemoteException;

}
