package examples.webservices.rpc.weatherEJB;

import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;

/**
 * This interface is the home interface for the WeatherBean.java,
 * which in WebLogic is implemented by the code-generated container
 * class WeatherBeanC. A home interface may support one or more create
 * methods, which must correspond to methods named "ejbCreate" in the EJBean.
 *
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */
public interface WeatherHome extends EJBHome {

  /**
   * This method corresponds to the ejbCreate method in the bean
   * "WeatherBean.java".
   * The parameter sets of the two methods are identical. When the client calls
   * <code>WeatherHome.create()</code>, the container
   * allocates an instance of the EJBean and calls <code>ejbCreate()</code>.
   *
   * @return                  Weather
   * @exception               RemoteException if there is
   *                          a communications or systems failure
   * @exception               CreateException
   *                          if there is a problem creating the bean
   * @see                     examples.ejb.basic.statelessSession.WeatherBean
   */
  Weather create() throws CreateException, RemoteException;
}
