package examples.xml;

import java.net.*;
import java.io.*;
import java.util.*;

/**
 * This client class works with the <tt>Sax</tt>, <tt>Dom</tt>, <tt>Attributes</tt>, <tt>GeneratedParser</tt>, and <tt>Entityresolution</tt> examples included in this package
 * to demonstrate how XML data can be passed and manipulated between 
 * a client and a JSP. 
 * <p>
 * This class reads the XML file and sends the data to a JSP using the HTTP 
 * POST method. The JSP then parses the XML data that it received from the 
 * <tt>Client</tt> and prints the content in the shell from which you started 
 * the WebLogic server.  
 * <p>
 * The various examples show how to use different parsers; for example, the 
 * <tt>sax</tt> example shows how to use a SAX parser to parse the XML data, 
 * the <tt>generatedParser</tt> example shows how to create and use a 
 * customized parser, and so on.
 * 
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.  
 */

public class Client {

  /**
   * Runs this Client from the command line.
   * <p>
   * The Client expects two arguments: the URL of the JSP and the
   * name of the XML file to be parsed.  The Client looks for the
   * XML file in the current directory.
   * <p>
   * To run the client, enter this command at the command line: 
   * <tt>java examples.xml.Client URL_of_the_jsp Filename.xml</tt>
   * 
   */

  public static void main(String[] args) throws Exception {
    if (args.length < 2) {
      System.out.println("Usage:  java examples.xml.Client URL Filename");
            
    }
    else {
      
      try {

        URL url = new URL(args[0]);
        String document = args[1];
         
        FileInputStream fis = new FileInputStream(document);
      
        byte[] buffer = new byte[1024*10];
        int bytes_read = 0;
              
        if ((bytes_read = fis.read(buffer)) != -1)
          {
            System.out.println("************************************************");  
            System.out.println("Sending XML file to " + args[0] +" for parsing...");
            URLConnection urlc = url.openConnection();
            urlc.setRequestProperty("Content-Type","text/xml");
            urlc.setDoOutput(true);
            urlc.setDoInput(true);
            PrintStream ps = new PrintStream(urlc.getOutputStream());
                
            // send xml to jsp
            ps.write(buffer, 0, bytes_read);
            ps.close();

            BufferedReader in = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
	      String inputLine;

	      while ((inputLine = in.readLine()) != null)
	      System.out.println(inputLine);

	      in.close();
    
            }              
          }
          catch (Exception e) {
          e.printStackTrace();
          }
       }
    }
}
