package examples.xml.entityresolution;

import java.io.PrintWriter;
import org.xml.sax.*;

/**
 * This class handles any errors encountered while parsing an XML document.
 */

public class MyErrorHandler implements ErrorHandler {

  private PrintWriter pw;

    /** Default contsructor */
  public MyErrorHandler() {}


    /** 
     * Constructor which takes a PrintWriter parameter to output information
     * to the shell from which you started the WebLogic server.
     */
  public MyErrorHandler(PrintWriter writer) {
    pw = writer;
  }


  //==========================================================================
  // ErrorHandler methods
  //==========================================================================

  /* 
   * Prints a message to the shell when an error occurred while parsing
   * the document.
   */
  public void error(SAXParseException exception) throws SAXException {
    pw.println("Error occurred when parsing document: "+exception);
    throw exception;
  }

  /* 
   * Prints a message to the shell when a fatal error occurred while parsing
   * the document.
   */
  public void fatalError(SAXParseException exception) throws SAXException {
    pw.println("Fatal error occurred when parsing document: "+exception);
    throw exception;
  }
       
  /* 
   * Prints a message to the shell when a warning occurred while parsing
   * the document.
   */
  public void warning(SAXParseException exception) throws SAXException {
    pw.println("Warning: "+exception);
    throw exception;
  }

}
