package examples.xml.messageformat;

import weblogic.rmi.RemoteException;
import java.io.*;
import java.util.*;
import javax.ejb.CreateException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.ejb.*;
import javax.naming.*;
import examples.ejb.basic.statefulSession.*;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.*;
import org.xml.sax.*;
import weblogic.jms.extensions.*;

import javax.naming.InitialContext;
import javax.naming.NamingException;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import examples.xml.messageformat.RequestHandler;

/**
 * This class reads the XML data from a JMS queue, parses it and and 
 * calls the <code>statefulSession.TraderBean</code> EJB to actually
 * perform the stock trade transaction.  The class then puts the output
 * of the trade on another JMS queue.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class MessageTraderBean implements MessageDrivenBean, MessageListener {

  public final static String JNDI_FACTORY="weblogic.jndi.WLInitialContextFactory";
  public final static StringBuffer buffer = new StringBuffer();  
   
  /**
   * Defines the JMS connection factory for the queue.
   */
  public final static String JMS_FACTORY="weblogic.examples.jms.QueueConnectionFactory";
  
  /**
  * Defines the queue.
  */
  public final static String QUEUE="weblogic.examples.jms.exampleQueueReceive";
   
  private QueueConnectionFactory qconFactory;
  private QueueConnection qcon;
  private QueueSession qsession;
  private QueueReceiver qreceiver;
  private QueueSender qsender;
  private Queue queuereceive;
  private boolean quit = false; 
  private XMLMessage xmlmessage;

  private static final boolean VERBOSE = true;
  private MessageDrivenContext m_context;
  
  // You might also consider using WebLogic's log service
  private void log(String s) {
    if (VERBOSE) System.out.println(s);
  } 
  
  /**
   * This method is not used by this example.
   *
   */
  public void ejbActivate() {
    log("ejbActivate called");
  }

  /**
   * This method is not used by this example.
   *
   */
  public void ejbRemove() {
    log("ejbRemove called");
  }

  /**
   * This method is not used by this example.
   *
   */
  public void ejbPassivate() {
    log("ejbPassivate called");
  }

  /**
   * Sets the session context.
   *
   * @param ctx               MessageDrivenContext Context for session
   */
  public void setMessageDrivenContext(MessageDrivenContext ctx) {
    log("setMessageDrivenContext called");
    m_context = ctx;
  }

  /**
   * This method is not used by this example.
   */
  public void ejbCreate () throws CreateException {
    log("ejbCreate called");
  }

  //
  // Implementation of MessageListener
  //

  /**
   * Retrieves the XML data from the first JMS queue then parses
   * the data using a SAX parser.  The method then calls the 
   * <code>Trader</code> stateful Session EJB to perform the actual
   * trade on the data.  Finally, this method creates a new XML
   * message which will be sent to a second JMS queue.
   *
   * @param msg the JMS message
   */
  public void onMessage(Message msg) 
  {
    xmlmessage = (XMLMessage) msg;
    RequestHandler rh = new RequestHandler();
    try {
      String txt = xmlmessage.getText();
    
      SAXParserFactory fact = SAXParserFactory.newInstance();
      SAXParser sp = fact.newSAXParser();
   
      InputSource inSource = new InputSource();
      inSource.setCharacterStream(new StringReader(txt));
      sp.parse(inSource, rh);
    } catch(JMSException ex) {
      ex.printStackTrace();
    } catch (Exception e) {
      e.printStackTrace();
      return;
    }
  
    java.util.Hashtable trade = rh.getData();
    System.out.println("trade " + trade.toString());
    if (! trade.isEmpty()) {
    try {
    
      // Create a trader object.
      Context ctxt          =  new InitialContext();
      TraderHome brokerage = (TraderHome) ctxt.lookup("statefulSession.TraderHome");
   
      // Give this trader a name.
      Trader trader = brokerage.create();
   
      // Do trade.
      if (((String) trade.get("action")).equals("buy")) {
            TradeResult tr = trader.buy("Erin", (String) trade.get("symbol"), 
                             Integer.parseInt((String) trade.get("numShares")));
        // send result via xml
        buffer.append("<traderesult action='bought' symbol='"+
                       (String) trade.get("symbol")+"' numShares='"+ tr.getNumberTraded() +
                        "' price ='"+ tr.getPrice() +"' changeInAccount ='" + trader.getBalance() +"'/>");
   
      } else if (((String) trade.get("action")).equals("sell")) {
                   TradeResult tr = trader.sell("Erin", (String) trade.get("symbol"), 
                                    Integer.parseInt((String) trade.get("numShares")));
          
       // send result via xml
       buffer.append("<traderesult action='sold' symbol='"+
                      (String) trade.get("symbol")+"' numShares='"+ tr.getNumberTraded() +
                       "' price ='"+ tr.getPrice() +"' changeInAccount ='" + trader.getBalance() +"'/>");
      }
        InitialContext ic = getInitialContext();
        init(ic, QUEUE);
        send(buffer.toString());
        buffer.delete(0,buffer.length());
        close();
        trader.remove();
      } catch (NamingException ne) {
        System.out.println(":::::::::::::: Error :::::::::::::::::");
        ne.printStackTrace();
      } catch (JMSException jmse) {
        System.out.println(":::::::::::::: Error :::::::::::::::::");
        jmse.printStackTrace();
      } catch (Exception e) {
        System.out.println(":::::::::::::: Error :::::::::::::::::");
        e.printStackTrace();
      }
    }
 }

  /**
   * Sends a message in the form of XML data to a JMS queue.
   * 
   * @param message the String message to be sent to the JMS queue
   */
  public void send(String message)
    throws JMSException
  {
    xmlmessage.setText(message);
    qsender.send(xmlmessage);
  }

  /**
   * Creates all the necessary objects for sending messages to a JMS queue.
   *
   * @param   ctx	JNDI initial context
   * @param	queueName	name of queue
   * @exception NamingException if operation cannot be performed
   * @exception JMSException if JMS fails to initialize due to internal error
   */
  public void init(Context ctx, String queueName)
    throws NamingException, JMSException
  {
    qconFactory = (QueueConnectionFactory) ctx.lookup(JMS_FACTORY);
    qcon = qconFactory.createQueueConnection();
    qsession = qcon.createQueueSession(false, Session.AUTO_ACKNOWLEDGE);
    queuereceive = (Queue) ctx.lookup(queueName);
    qsender = qsession.createSender(queuereceive);
    xmlmessage = ((WLQueueSession)qsession).createXMLMessage();
    qcon.start();
  }
   
  // gets the initial context to the server
  private static InitialContext getInitialContext()
    throws NamingException
  {
    Hashtable env = new Hashtable();
    env.put(Context.INITIAL_CONTEXT_FACTORY, "weblogic.jndi.WLInitialContextFactory");
    env.put(Context.PROVIDER_URL, "t3://localhost:7001");
    return new InitialContext(env);
  }

  /**
   * Closes all JMS objects.
   * 
   * @exception JMSException if JMS fails to close objects due to internal error
   */
  public void close()
    throws JMSException
  {
    qsession.close();
    qsender.close();  
    qcon.close();
  }

  //
  // Implementation of MessageListener
  //
  static void p(String s) {
    System.out.println("*** <MessageTraderBean> " + s);
  }
}


