package examples.xml.xslt;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/**
 * This stateless Session Bean generates XML content that is later
 * displayed to various client types.  
 * Since the point of this example is to demonstrate the separation of 
 * content generation and presentation, this EJB generates static content. 
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class ContentBean implements SessionBean {

  private static final boolean VERBOSE = true;
  private SessionContext ctx;

  // You might also consider using WebLogic's log service
  private void log(String s) {
    if (VERBOSE) System.out.println("ContentBean: "+s);
  } 
  
  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   *
   */
  public void ejbActivate() {
    log("ejbActivate called");
  }

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   *
   */
  public void ejbRemove() {
    log("ejbRemove called");
  }

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   *
   */
  public void ejbPassivate() {
    log("ejbPassivate called");
  }

  /**
   * Sets the session context.  
   *
   * @param ctx               SessionContext Context for session
   */
  public void setSessionContext(SessionContext ctx) {
    log("setSessionContext called");
    this.ctx = ctx;
  }

  /**
   * This method corresponds to the <code>create</code> method in the home 
   * interface <code>ContentHome</code>.
   * The parameter sets of the two methods are identical. When the client calls
   * <code>ContentHome.create</code>, the container allocates an instance of 
   * the EJBean and calls <code>ejbCreate</code>.
   *
   * @exception               javax.ejb.CreateException if there is
   *                          a communications or systems failure
   * @see                     examples.xml.xslt.ContentHome
   */
  public void ejbCreate () throws CreateException {
    log("ejbCreate called");
  }


  /**
   * Generates XML content to be displayed to various client types. 
   *
   * @return                  String content in the form of XML
   * @exception               RemoteException if there is
   *                          a communications or systems failure
   */
  public String generateContent() {
      String retString = "<content><title>XSLT example</title><description>This example demonstrates the use of XML and XSLT as a way to separate content from presentation.</description><html_note>ContentBean generates the content in the form of an XML document. Presentation.jsp uses XSLT to transform the XML document to a format that is appropriate for the client making the request. Since you are currently viewing this page in an HTML browser, more information can be displayed than if you were viewing this page in a client with a smaller display such as a WAP-enabled mobile telephone. See the example documentation for instructions on viewing this page using a WAP emulator. </html_note><wap_note>You are viewing this page from a WAP-enabled client.</wap_note></content>";
    return retString;
  }


}








