package examples.xml.xslt;

import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;

/**
 * This interface is the home interface for <code>ContentBean</code>,
 * which in WebLogic is implemented by the code-generated container
 * class <code>ContentBeanEOImpl</code>. A home interface may support one 
 * or more <code>create</code> methods, which must correspond to methods 
 * named <code>ejbCreate</code> in the EJBean.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */
public interface ContentHome extends EJBHome {

  /**
   * This method corresponds to the <code>ejbCreate</code> method of
   * <code>ContenBean</code>.
   * The parameter sets of the two methods are identical. When the client calls
   * <code>ContentHome.create</code>, the container
   * allocates an instance of the EJBean and calls <code>ejbCreate</code>.
   *
   * @return                  Content
   * @exception               RemoteException if there is
   *                          a communications or systems failure
   * @exception               CreateException
   *                          if there is a problem creating the bean
   * @see                     examples.xml.xslt.ContentBean
   */
  Content create() throws CreateException, RemoteException;
}
