<!-- Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.-->

<!-- include xmlx tag library -->
<%@ taglib uri="xmlx.tld" prefix="x"%>

<!-- import required classes -->
<%@ page import="
    javax.naming.*,
    javax.ejb.*,
    java.rmi.RemoteException,
    java.rmi.Remote,
    java.util.*,
    examples.xml.xslt.* 
    org.xml.sax.SAXException
"%>

<%
  Content c = null;
  String content = null;
  try {
    // Contact the ContentBean container through JNDI.
    Context ctx = new InitialContext();
    ContentHome home = (ContentHome) ctx.lookup("xml-xslt-ContentHome");

    c = (Content) home.create();

    //get content from EJB
    content = c.generateContent();
    String output = null;

    //determine client type, set "output" and contentType accordingly
    String clientType = request.getHeader("User-Agent");
    if (clientType.indexOf("WAP") != -1) {
      output = "wml";
      response.setContentType("text/vnd.wap.wml");
    } else {
      output = "html";
      response.setContentType("text/html");
    }
%>

<!-- transform document according to value of "output" -->
<x:xslt media="<%=output%>">
  <x:xml><%=content%></x:xml>
  <x:stylesheet media="html" uri="html.xsl"/>
  <x:stylesheet media="wml" uri="wml.xsl"/>
</x:xslt>

<%

  } catch (Exception e) {
    System.out.println("error: " +e);
    out.println("error: "+e);
  }

%>

