(* pputil.sml
 *)

(* emulation of OCaml pp functions available at top level *)

structure PPUtil =
struct

structure TextToken =
  struct
    type token = string
    type style = unit
    fun string t = t
    fun style t = ()
    fun size t = String.size t
  end;

structure PP = PPStreamFn(
    structure Token = TextToken
    structure Device = SimpleTextIODev)

val wid = 80
(* single ppStream directed to stdOut *)
val ppStrm = PP.openStream(SimpleTextIODev.openDev{dst=TextIO.stdOut, wid=wid})

fun open_box n = PP.openBox ppStrm (PP.Rel n)
val open_hbox = PP.openHBox ppStrm
fun open_vbox n = PP.openVBox ppStrm (PP.Rel n)
fun open_hvbox n = PP.openHVBox ppStrm (PP.Rel n)
fun open_vohbox n = PP.openHOVBox ppStrm (PP.Rel n)
fun close_box () = PP.closeBox ppStrm

fun print_break nsp offset = PP.break ppStrm {nsp=nsp, offset=offset}
val print_cut = PP.cut ppStrm
fun print_space () = PP.space ppStrm 1
val print_nbspace = PP.nbSpace ppStrm
fun print_newline () = (PP.newline ppStrm; PP.flushStream ppStrm)
val print_string = PP.string ppStrm
fun print_int n = PP.string ppStrm (Int.toString n)
fun print_flush () = PP.flushStream ppStrm

end (* structure PPUtil *)

