functor SimpleBoolLexFun(structure Tokens: SimpleBool_TOKENS)=
   struct
    structure UserDeclarations =
      struct
(* lexer.lex
   The lexical analyzer: lexer.ml is generated automatically
   from lexer.mll.
   
   The only modification commonly needed here is adding new keywords to the 
   list of reserved words at the top.  
*)

structure Tokens = Tokens

type pos = int
type svalue = Tokens.svalue
type ('a,'b) token = ('a,'b) Tokens.token
type lexresult= (svalue,pos) token

fun error (startpos,endpos) msg = 
    TextIO.output (TextIO.stdOut,
		   String.concat["Lexer Error (", Int.toString startpos, ",", Int.toString endpos, ") ",msg,"\n"])

fun inc (ri as ref i) = (ri := i+1)
fun dec (ri as ref i) = (ri := i-1)

val lineno   = ref 1
fun newline () = (inc lineno)

val commentDepth = ref 0

val stringStart = ref 0
val charlist : string list ref = ref nil
fun resetString pos = (stringStart := pos; charlist := nil)
fun addString (charlist,s:string) = charlist := s :: (!charlist)
fun addChar (charlist, c:char) = addString(charlist, String.str c)
fun makeString () = (concat(rev(!charlist)) before charlist := nil)

fun eof () =
    let val pos = Int.max(!stringStart+2, 0)
     in if !commentDepth > 0 then
	  error (0,0) "unclosed comment"
        else if !charlist <> [] then
          error (0,0) "unclosed string"
	else ();
	Tokens.EOF(0,0)
    end	

end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s = [ 
 (0, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (1, 
"\007\007\007\007\007\007\007\007\007\087\090\007\007\089\007\007\
\\007\007\007\007\007\007\007\007\007\007\007\007\007\007\007\007\
\\087\048\086\085\084\008\008\083\082\081\079\008\078\076\075\073\
\\069\069\069\069\069\069\069\069\069\069\067\066\063\059\058\048\
\\008\052\054\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\050\008\049\048\047\
\\008\017\043\017\017\039\034\017\017\032\017\017\026\017\017\017\
\\017\017\017\017\019\017\017\017\017\017\017\015\011\010\008\007\
\\007"
),
 (3, 
"\091\091\091\091\091\091\091\091\091\091\097\091\091\096\091\091\
\\091\091\091\091\091\091\091\091\091\091\091\091\091\091\091\091\
\\091\091\091\091\091\091\091\091\091\091\094\091\091\091\091\092\
\\091\091\091\091\091\091\091\091\091\091\091\091\091\091\091\091\
\\091\091\091\091\091\091\091\091\091\091\091\091\091\091\091\091\
\\091\091\091\091\091\091\091\091\091\091\091\091\091\091\091\091\
\\091\091\091\091\091\091\091\091\091\091\091\091\091\091\091\091\
\\091\091\091\091\091\091\091\091\091\091\091\091\091\091\091\091\
\\091"
),
 (5, 
"\115\115\115\115\115\115\115\115\115\115\118\115\115\116\115\115\
\\115\115\115\115\115\115\115\115\115\115\115\115\115\115\115\115\
\\098\098\114\098\098\098\098\098\098\098\098\098\098\098\098\098\
\\098\098\098\098\098\098\098\098\098\098\098\098\098\098\098\098\
\\098\098\098\098\098\098\098\098\098\098\098\098\098\098\098\098\
\\098\098\098\098\098\098\098\098\098\098\098\098\099\098\098\098\
\\098\098\098\098\098\098\098\098\098\098\098\098\098\098\098\098\
\\098\098\098\098\098\098\098\098\098\098\098\098\098\098\098\098\
\\098"
),
 (8, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\009\009\000\000\000\000\009\000\009\000\000\
\\000\000\000\000\000\000\000\000\000\000\009\000\000\000\000\000\
\\009\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\009\000\000\000\
\\009\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\009\000\
\\000"
),
 (11, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\014\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\013\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\012\000\000\
\\000"
),
 (15, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\
\\000"
),
 (17, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (19, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\018\018\018\018\023\018\018\018\018\018\018\018\
\\018\018\020\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (20, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\021\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (21, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\018\022\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (23, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\018\024\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (24, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\025\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (26, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\027\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (27, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\028\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (28, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\029\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (29, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\030\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (30, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\031\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (32, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\018\018\033\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (34, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\035\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (35, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\018\018\018\018\018\018\018\018\036\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (36, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\037\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (37, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\018\038\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (39, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\018\018\018\018\018\018\018\018\040\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (40, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\041\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (41, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\018\042\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (43, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\018\018\018\018\018\044\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (44, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\045\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (45, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\046\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (50, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\051\000\000\000\
\\000"
),
 (52, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\053\000\000\000\000\000\000\000\000\
\\053\053\053\053\053\053\053\053\053\053\000\000\000\000\000\000\
\\000\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\
\\053\053\053\053\053\053\053\053\053\053\053\000\000\000\000\053\
\\000\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\
\\053\053\053\053\053\053\053\053\053\053\053\000\000\000\000\000\
\\000"
),
 (54, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\053\000\000\000\000\000\000\000\000\
\\053\053\053\053\053\053\053\053\053\053\000\000\000\000\000\000\
\\000\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\
\\053\053\053\053\053\053\053\053\053\053\053\000\000\000\000\053\
\\000\053\053\053\053\053\053\053\053\053\053\053\053\053\053\055\
\\053\053\053\053\053\053\053\053\053\053\053\000\000\000\000\000\
\\000"
),
 (55, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\053\000\000\000\000\000\000\000\000\
\\053\053\053\053\053\053\053\053\053\053\000\000\000\000\000\000\
\\000\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\
\\053\053\053\053\053\053\053\053\053\053\053\000\000\000\000\053\
\\000\053\053\053\053\053\053\053\053\053\053\053\053\053\053\056\
\\053\053\053\053\053\053\053\053\053\053\053\000\000\000\000\000\
\\000"
),
 (56, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\053\000\000\000\000\000\000\000\000\
\\053\053\053\053\053\053\053\053\053\053\000\000\000\000\000\000\
\\000\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\
\\053\053\053\053\053\053\053\053\053\053\053\000\000\000\000\053\
\\000\053\053\053\053\053\053\053\053\053\053\053\057\053\053\053\
\\053\053\053\053\053\053\053\053\053\053\053\000\000\000\000\000\
\\000"
),
 (59, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\061\060\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (61, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\062\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (63, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\065\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\064\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (67, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\009\009\000\000\000\000\009\000\009\000\000\
\\000\000\000\000\000\000\000\000\000\000\009\000\000\068\000\000\
\\009\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\009\000\000\000\
\\009\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\009\000\
\\000"
),
 (69, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\071\000\
\\070\070\070\070\070\070\070\070\070\070\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (71, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\072\072\072\072\072\072\072\072\072\072\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (73, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\074\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (76, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\009\009\000\000\000\000\009\000\009\000\000\
\\000\000\000\000\000\000\000\000\000\000\009\000\000\000\077\000\
\\009\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\009\000\000\000\
\\009\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\009\000\
\\000"
),
 (79, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\080\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (87, 
"\000\000\000\000\000\000\000\000\000\088\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\088\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (89, 
"\000\000\000\000\000\000\000\000\000\000\090\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (92, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\093\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (94, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\095\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (96, 
"\000\000\000\000\000\000\000\000\000\000\097\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (99, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\113\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\110\110\110\110\110\110\110\110\110\110\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\109\000\107\000\
\\000\106\105\000\000\000\104\000\000\000\000\000\000\000\103\000\
\\000\000\102\000\101\000\100\000\000\000\000\000\000\000\000\000\
\\000"
),
 (107, 
"\108\108\108\108\108\108\108\108\108\108\000\108\108\108\108\108\
\\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\
\\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\
\\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\
\\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\
\\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\
\\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\
\\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\
\\108"
),
 (110, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\111\111\111\111\111\111\111\111\111\111\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (111, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\112\112\112\112\112\112\112\112\112\112\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (116, 
"\000\000\000\000\000\000\000\000\000\000\117\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
(0, "")]
fun f x = x 
val s = map f (rev (tl (rev s))) 
exception LexHackingError 
fun look ((j,x)::r, i: int) = if i = j then x else look(r, i) 
  | look ([], i) = raise LexHackingError
fun g {fin=x, trans=i} = {fin=x, trans=look(s,i)} 
in Vector.fromList(map g 
[{fin = [], trans = 0},
{fin = [], trans = 1},
{fin = [], trans = 1},
{fin = [], trans = 3},
{fin = [], trans = 3},
{fin = [], trans = 5},
{fin = [], trans = 5},
{fin = [(N 153)], trans = 0},
{fin = [(N 147),(N 153)], trans = 8},
{fin = [(N 147)], trans = 8},
{fin = [(N 89),(N 153)], trans = 0},
{fin = [(N 60),(N 153)], trans = 11},
{fin = [(N 98)], trans = 0},
{fin = [(N 104)], trans = 0},
{fin = [(N 101)], trans = 0},
{fin = [(N 79),(N 153)], trans = 15},
{fin = [(N 84)], trans = 0},
{fin = [(N 144),(N 153)], trans = 17},
{fin = [(N 144)], trans = 17},
{fin = [(N 144),(N 153)], trans = 19},
{fin = [(N 144)], trans = 20},
{fin = [(N 144)], trans = 21},
{fin = [(N 25),(N 144)], trans = 17},
{fin = [(N 144)], trans = 23},
{fin = [(N 144)], trans = 24},
{fin = [(N 15),(N 144)], trans = 17},
{fin = [(N 144),(N 153)], trans = 26},
{fin = [(N 144)], trans = 27},
{fin = [(N 144)], trans = 28},
{fin = [(N 144)], trans = 29},
{fin = [(N 144)], trans = 30},
{fin = [(N 43),(N 144)], trans = 17},
{fin = [(N 144),(N 153)], trans = 32},
{fin = [(N 10),(N 144)], trans = 17},
{fin = [(N 144),(N 153)], trans = 34},
{fin = [(N 144)], trans = 35},
{fin = [(N 144)], trans = 36},
{fin = [(N 144)], trans = 37},
{fin = [(N 31),(N 144)], trans = 17},
{fin = [(N 144),(N 153)], trans = 39},
{fin = [(N 144)], trans = 40},
{fin = [(N 144)], trans = 41},
{fin = [(N 20),(N 144)], trans = 17},
{fin = [(N 144),(N 153)], trans = 43},
{fin = [(N 144)], trans = 44},
{fin = [(N 144)], trans = 45},
{fin = [(N 48),(N 144)], trans = 17},
{fin = [(N 50),(N 153)], trans = 0},
{fin = [(N 149),(N 153)], trans = 0},
{fin = [(N 93),(N 153)], trans = 0},
{fin = [(N 75),(N 153)], trans = 50},
{fin = [(N 87)], trans = 0},
{fin = [(N 141),(N 153)], trans = 52},
{fin = [(N 141)], trans = 52},
{fin = [(N 141),(N 153)], trans = 54},
{fin = [(N 141)], trans = 55},
{fin = [(N 141)], trans = 56},
{fin = [(N 36),(N 141)], trans = 52},
{fin = [(N 95),(N 153)], trans = 0},
{fin = [(N 70),(N 153)], trans = 59},
{fin = [(N 116)], trans = 0},
{fin = [(N 73)], trans = 61},
{fin = [(N 123)], trans = 0},
{fin = [(N 77),(N 153)], trans = 63},
{fin = [(N 119)], trans = 0},
{fin = [(N 113)], trans = 0},
{fin = [(N 64),(N 153)], trans = 0},
{fin = [(N 147),(N 153)], trans = 67},
{fin = [(N 107)], trans = 0},
{fin = [(N 138),(N 153)], trans = 69},
{fin = [(N 138)], trans = 69},
{fin = [], trans = 71},
{fin = [(N 135)], trans = 71},
{fin = [(N 68),(N 153)], trans = 73},
{fin = [(N 126)], trans = 0},
{fin = [(N 62),(N 153)], trans = 0},
{fin = [(N 147),(N 153)], trans = 76},
{fin = [(N 110)], trans = 0},
{fin = [(N 66),(N 153)], trans = 0},
{fin = [(N 58),(N 153)], trans = 79},
{fin = [(N 129)], trans = 0},
{fin = [(N 91),(N 153)], trans = 0},
{fin = [(N 81),(N 153)], trans = 0},
{fin = [(N 52),(N 153)], trans = 0},
{fin = [(N 56),(N 153)], trans = 0},
{fin = [(N 54),(N 153)], trans = 0},
{fin = [(N 151),(N 153)], trans = 0},
{fin = [(N 7),(N 153)], trans = 87},
{fin = [(N 7)], trans = 87},
{fin = [(N 4),(N 153)], trans = 89},
{fin = [(N 4)], trans = 0},
{fin = [(N 166)], trans = 0},
{fin = [(N 166)], trans = 92},
{fin = [(N 156)], trans = 0},
{fin = [(N 166)], trans = 94},
{fin = [(N 164)], trans = 0},
{fin = [(N 161),(N 166)], trans = 96},
{fin = [(N 161)], trans = 0},
{fin = [(N 215)], trans = 0},
{fin = [(N 211),(N 215)], trans = 99},
{fin = [(N 194)], trans = 0},
{fin = [(N 191)], trans = 0},
{fin = [(N 188)], trans = 0},
{fin = [(N 185)], trans = 0},
{fin = [(N 182)], trans = 0},
{fin = [(N 179)], trans = 0},
{fin = [(N 176)], trans = 0},
{fin = [], trans = 107},
{fin = [(N 204)], trans = 0},
{fin = [(N 197)], trans = 0},
{fin = [], trans = 110},
{fin = [], trans = 111},
{fin = [(N 209)], trans = 0},
{fin = [(N 200)], trans = 0},
{fin = [(N 168),(N 215)], trans = 0},
{fin = [(N 213),(N 215)], trans = 0},
{fin = [(N 173),(N 213),(N 215)], trans = 116},
{fin = [(N 173)], trans = 0},
{fin = [(N 173),(N 213)], trans = 0}])
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val COMMENT = STARTSTATE 3;
val INITIAL = STARTSTATE 1;
val STRING = STARTSTATE 5;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

fun makeLexer yyinput =
let	val yygone0=1
	val yyb = ref "\n" 		(* buffer *)
	val yybl = ref 1		(*buffer length *)
	val yybufpos = ref 1		(* location of next character to use *)
	val yygone = ref yygone0	(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex () : Internal.result =
let fun continue() = lex() in
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0) =
	let fun action (i,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let fun yymktext() = substring(!yyb,i0,i-i0)
			     val yypos = i0+ !yygone
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  10 => (Tokens.IF(yypos,yypos+2))
| 101 => (Tokens.BARGT(yypos,yypos+2))
| 104 => (Tokens.BARRSQUARE(yypos,yypos+2))
| 107 => (Tokens.COLONEQ(yypos,yypos+2))
| 110 => (Tokens.ARROW(yypos,yypos+2))
| 113 => (Tokens.LEFTARROW(yypos,yypos+2))
| 116 => (Tokens.DARROW(yypos,yypos+2))
| 119 => (Tokens.LEFTDARROW(yypos,yypos+2))
| 123 => (Tokens.DDARROW(yypos,yypos+3))
| 126 => (YYBEGIN COMMENT; commentDepth := 1; lex())
| 129 => (error (yypos,yypos+2) "Unmatched end of comment"; lex())
| 135 => let val yytext=yymktext() in Tokens.FLOATV(valOf(Real.fromString yytext),yypos,yypos+size yytext) end
| 138 => let val yytext=yymktext() in Tokens.INTV(valOf(Int.fromString(yytext)),yypos,yypos+size yytext) end
| 141 => let val yytext=yymktext() in Tokens.UCID(yytext,yypos,yypos+size yytext) end
| 144 => let val yytext=yymktext() in Tokens.LCID(yytext,yypos,yypos+size yytext) end
| 147 => let val yytext=yymktext() in if yytext = ":" then Tokens.COLON(yypos,yypos+1)
	          else if yytext = "::" then Tokens.COLONCOLON(yypos,yypos+2)
		  else Tokens.LCID(yytext,yypos,yypos+size yytext) end
| 149 => let val yytext=yymktext() in Tokens.LCID(yytext,yypos,yypos+1) end
| 15 => (Tokens.THEN(yypos,yypos+4))
| 151 => (resetString(yypos); YYBEGIN STRING; lex())
| 153 => (error (yypos,yypos+1) "Illegal character"; lex())
| 156 => (inc commentDepth; lex())
| 161 => (newline(); lex())
| 164 => (dec commentDepth; if !commentDepth=0 then YYBEGIN INITIAL else (); lex())
| 166 => (lex())
| 168 => (YYBEGIN INITIAL; Tokens.STRINGV(makeString(),!stringStart,yypos+1))
| 173 => (error (!stringStart, yypos) "unclosed string"; Tokens.EOF(0,0))
| 176 => (addString(charlist, "\007"); lex())
| 179 => (addString(charlist, "\008"); lex())
| 182 => (addString(charlist, "\012"); lex())
| 185 => (addString(charlist, "\010"); lex())
| 188 => (addString(charlist, "\013"); lex())
| 191 => (addString(charlist, "\009"); lex())
| 194 => (addString(charlist, "\011"); lex())
| 197 => (addString(charlist, "\\"); lex())
| 20 => (Tokens.ELSE(yypos,yypos+4))
| 200 => (addString(charlist, "\""); lex())
| 204 => (error (yypos,yypos+2) "illegal control escape; must be one of \
	  \@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_";
	 lex())
| 209 => let val yytext=yymktext() in let val x = Char.ord(String.sub(yytext,1))*100
	     +Char.ord(String.sub(yytext,2))*10
	     +Char.ord(String.sub(yytext,3))
	     -((Char.ord #"0")*111)
  in (if x>255
      then error (yypos,yypos+4) "illegal ascii escape"
      else addChar(charlist, Char.chr x);
      lex())
  end end
| 211 => (error (yypos,yypos+1) "illegal string escape"; lex())
| 213 => (error (yypos,yypos+1) "illegal non-printing character in string";
                         lex())
| 215 => let val yytext=yymktext() in addString(charlist,yytext); lex() end
| 25 => (Tokens.TRUE(yypos,yypos+4))
| 31 => (Tokens.FALSE(yypos,yypos+5))
| 36 => (Tokens.BOOL(yypos,yypos+6))
| 4 => (newline(); lex())
| 43 => (Tokens.LAMBDA(yypos,yypos+6))
| 48 => (Tokens.BIND(yypos,yypos+4))
| 50 => (Tokens.USCORE(yypos,yypos+1))
| 52 => (Tokens.APOSTROPHE(yypos,yypos+1))
| 54 => (Tokens.HASH(yypos,yypos+1))
| 56 => (Tokens.TRIANGLE(yypos,yypos+1))
| 58 => (Tokens.STAR(yypos,yypos+1))
| 60 => (Tokens.VBAR(yypos,yypos+1))
| 62 => (Tokens.DOT(yypos,yypos+1))
| 64 => (Tokens.SEMI(yypos,yypos+1))
| 66 => (Tokens.COMMA(yypos,yypos+1))
| 68 => (Tokens.SLASH(yypos,yypos+1))
| 7 => (lex())
| 70 => (Tokens.EQ(yypos,yypos+1))
| 73 => (Tokens.EQEQ(yypos,yypos+2))
| 75 => (Tokens.LSQUARE(yypos,yypos+1))
| 77 => (Tokens.LT(yypos,yypos+1))
| 79 => (Tokens.LCURLY(yypos,yypos+1))
| 81 => (Tokens.LPAREN(yypos,yypos+1))
| 84 => (Tokens.LCURLYBAR(yypos,yypos+2))
| 87 => (Tokens.LSQUAREBAR(yypos,yypos+2))
| 89 => (Tokens.RCURLY(yypos,yypos+1))
| 91 => (Tokens.RPAREN(yypos,yypos+1))
| 93 => (Tokens.RSQUARE(yypos,yypos+1))
| 95 => (Tokens.GT(yypos,yypos+1))
| 98 => (Tokens.BARRCURLY(yypos,yypos+2))
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Unsafe.Vector.sub(Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves
) else	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof ()
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := substring(!yyb,i0,l-i0)^newchars;
		     yygone := !yygone+i0;
		     yybl := size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = Char.ord(Unsafe.CharVector.sub(!yyb,l))
		val NewChar = if NewChar<128 then NewChar else 128
		val NewState = Char.ord(Unsafe.CharVector.sub(trans,NewChar))
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if substring(!yyb,!yybufpos-1,1)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
end
  in lex
  end
end
