/* generate a simple test terrain
 *
 * To compile:
 *	gcc -I/sw/include -o gen gen.c -L/sw/lib -lnetpbm
 */

#include <stdio.h>
#include <math.h>
#include "pgm.h"
#include "ppm.h"

#define	SZ 513
#define CX 192
#define CZ 192
#define SEA_LEVEL 100

typedef enum {
    WATER, SAND, GRASS
} Color_t;

static inline float dist (int r, int c)
{
    float dx = (float)(CX - c);
    float dz = (float)(CZ - r);
    return sqrt(dx*dx + dz*dz);
}

unsigned short	hf[SZ][SZ];
unsigned char	water[SZ][SZ];
Color_t		color[SZ][SZ];

main ()
{
    int		r, c;
    gray	gRow[SZ];
    pixel	pRow[SZ];

    for (r = 0;  r < SZ;  r++) {
	for (c = 0;  c < SZ;  c++) {
	    float d = dist(r, c);
	    if (d < 15) {
	      /* in water */
		hf[r][c] = SEA_LEVEL;
		water[r][c] = 1 + 3 * (15 - (int)d);
		color[r][c] = WATER;
	    }
	    else {
		hf[r][c] = SEA_LEVEL + 1 + 4 * (int)d;
		water[r][c] = 0;
		if (d < 25) {
		  /* on beach */
		    color[r][c] = SAND;
		}
		else {
		  /* on grass */
		    color[r][c] = GRASS;
		}
	    }
	}
    }

  /* write files */
    FILE *strm = fopen ("hf.pgm", "wb");
    pgm_writepgminit (strm, SZ, SZ, 65535, 0);
    for (r = 0;  r < SZ;  r++) {
	for (c = 0;  c < SZ;  c++) {
	    gRow[c] = hf[r][c];
	}
	pgm_writepgmrow (strm, gRow, SZ, 65535, 0);
    }
    fclose (strm);

    strm = fopen ("water.pgm", "wb");
    pgm_writepgminit (strm, SZ, SZ, 255, 0);
    for (r = 0;  r < SZ;  r++) {
	for (c = 0;  c < SZ;  c++) {
	    gRow[c] = water[r][c];
	}
	pgm_writepgmrow (strm, gRow, SZ, 255, 0);
    }
    fclose (strm);

    strm = fopen ("color.ppm", "wb");
    ppm_writeppminit (strm, SZ, SZ, 255, 0);
    for (r = 0;  r < SZ;  r++) {
	for (c = 0;  c < SZ;  c++) {
	    switch (color[r][c]) {
	      case WATER:
		PPM_PUTR(pRow[c], 33);
		PPM_PUTG(pRow[c], 67);
		PPM_PUTB(pRow[c], 183);
		break;
	      case SAND:
		PPM_PUTR(pRow[c], 220);
		PPM_PUTG(pRow[c], 210);
		PPM_PUTB(pRow[c], 180);
		break;
	      case GRASS:
		PPM_PUTR(pRow[c], 59);
		PPM_PUTG(pRow[c], 94);
		PPM_PUTB(pRow[c], 54);
		break;
	    }
	}
	ppm_writeppmrow (strm, pRow, SZ, 255, 0);
    }
    fclose (strm);

}

