/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

final class MysqlDefs {
    static final int SLEEP = 0;
    static final int QUIT = 1;
    static final int INIT_DB = 2;
    static final int QUERY = 3;
    static final int FIELD_LIST = 4;
    static final int CREATE_DB = 5;
    static final int DROP_DB = 6;
    static final int RELOAD = 7;
    static final int SHUTDOWN = 8;
    static final int STATISTICS = 9;
    static final int PROCESS_INFO = 10;
    static final int CONNECT = 11;
    static final int PROCESS_KILL = 12;
    static final int DEBUG = 13;
    static final int PING = 14;
    static final int TIME = 15;
    static final int DELAYED_INSERT = 16;
    static final int CHANGE_USER = 17;
    static final int COM_BINLOG_DUMP = 18;
    static final int COM_TABLE_DUMP = 19;
    static final int COM_CONNECT_OUT = 20;
    static final int COM_REGISTER_SLAVE = 21;
    static final int COM_PREPARE = 22;
    static final int COM_EXECUTE = 23;
    static final int COM_LONG_DATA = 24;
    static final int FIELD_TYPE_DECIMAL = 0;
    static final int FIELD_TYPE_TINY = 1;
    static final int FIELD_TYPE_SHORT = 2;
    static final int FIELD_TYPE_LONG = 3;
    static final int FIELD_TYPE_FLOAT = 4;
    static final int FIELD_TYPE_DOUBLE = 5;
    static final int FIELD_TYPE_NULL = 6;
    static final int FIELD_TYPE_TIMESTAMP = 7;
    static final int FIELD_TYPE_LONGLONG = 8;
    static final int FIELD_TYPE_INT24 = 9;
    static final int FIELD_TYPE_DATE = 10;
    static final int FIELD_TYPE_TIME = 11;
    static final int FIELD_TYPE_DATETIME = 12;
    static final int FIELD_TYPE_YEAR = 13;
    static final int FIELD_TYPE_NEWDATE = 14;
    static final int FIELD_TYPE_ENUM = 247;
    static final int FIELD_TYPE_SET = 248;
    static final int FIELD_TYPE_TINY_BLOB = 249;
    static final int FIELD_TYPE_MEDIUM_BLOB = 250;
    static final int FIELD_TYPE_LONG_BLOB = 251;
    static final int FIELD_TYPE_BLOB = 252;
    static final int FIELD_TYPE_VAR_STRING = 253;
    static final int FIELD_TYPE_STRING = 254;
    static final int ER_WARNING_NOT_COMPLETE_ROLLBACK = 1196;
    static final int MAX_ROWS = 50000000;

    MysqlDefs() {
    }

    static int mysqlToJavaType(int mysqlType) {
        int jdbcType;
        switch (mysqlType) {
            case 0: {
                jdbcType = 3;
                break;
            }
            case 1: {
                jdbcType = -6;
                break;
            }
            case 2: {
                jdbcType = 5;
                break;
            }
            case 3: {
                jdbcType = 4;
                break;
            }
            case 4: {
                jdbcType = 6;
                break;
            }
            case 5: {
                jdbcType = 8;
                break;
            }
            case 6: {
                jdbcType = 0;
                break;
            }
            case 7: {
                jdbcType = 93;
                break;
            }
            case 8: {
                jdbcType = -5;
                break;
            }
            case 9: {
                jdbcType = 4;
                break;
            }
            case 10: {
                jdbcType = 91;
                break;
            }
            case 11: {
                jdbcType = 92;
                break;
            }
            case 12: {
                jdbcType = 93;
                break;
            }
            case 13: {
                jdbcType = 91;
                break;
            }
            case 14: {
                jdbcType = 91;
                break;
            }
            case 247: {
                jdbcType = 1;
                break;
            }
            case 248: {
                jdbcType = 1;
                break;
            }
            case 249: {
                jdbcType = -3;
                break;
            }
            case 250: {
                jdbcType = -4;
                break;
            }
            case 251: {
                jdbcType = -4;
                break;
            }
            case 252: {
                jdbcType = -4;
                break;
            }
            case 253: {
                jdbcType = 12;
                break;
            }
            case 254: {
                jdbcType = 1;
                break;
            }
            default: {
                jdbcType = 12;
            }
        }
        return jdbcType;
    }

    static int mysqlToJavaType(String mysqlType) {
        if (mysqlType.equalsIgnoreCase("TINYINT")) {
            return -6;
        }
        if (mysqlType.equalsIgnoreCase("SMALLINT")) {
            return 5;
        }
        if (mysqlType.equalsIgnoreCase("MEDIUMINT")) {
            return 5;
        }
        if (mysqlType.equalsIgnoreCase("INT")) {
            return 4;
        }
        if (mysqlType.equalsIgnoreCase("INTEGER")) {
            return 4;
        }
        if (mysqlType.equalsIgnoreCase("BIGINT")) {
            return -5;
        }
        if (mysqlType.equalsIgnoreCase("INT24")) {
            return -5;
        }
        if (mysqlType.equalsIgnoreCase("REAL")) {
            return 7;
        }
        if (mysqlType.equalsIgnoreCase("FLOAT")) {
            return 6;
        }
        if (mysqlType.equalsIgnoreCase("DECIMAL")) {
            return 3;
        }
        if (mysqlType.equalsIgnoreCase("NUMERIC")) {
            return 2;
        }
        if (mysqlType.equalsIgnoreCase("DOUBLE")) {
            return 8;
        }
        if (mysqlType.equalsIgnoreCase("CHAR")) {
            return 1;
        }
        if (mysqlType.equalsIgnoreCase("VARCHAR")) {
            return 12;
        }
        if (mysqlType.equalsIgnoreCase("DATE")) {
            return 91;
        }
        if (mysqlType.equalsIgnoreCase("TIME")) {
            return 92;
        }
        if (mysqlType.equalsIgnoreCase("TIMESTAMP")) {
            return 93;
        }
        if (mysqlType.equalsIgnoreCase("DATETIME")) {
            return 93;
        }
        if (mysqlType.equalsIgnoreCase("TINYBLOB")) {
            return -2;
        }
        if (mysqlType.equalsIgnoreCase("BLOB")) {
            return -3;
        }
        if (mysqlType.equalsIgnoreCase("MEDIUMBLOB")) {
            return -3;
        }
        if (mysqlType.equalsIgnoreCase("LONGBLOB")) {
            return -4;
        }
        if (mysqlType.equalsIgnoreCase("TINYTEXT")) {
            return 12;
        }
        if (mysqlType.equalsIgnoreCase("TEXT")) {
            return -1;
        }
        if (mysqlType.equalsIgnoreCase("MEDIUMTEXT")) {
            return -1;
        }
        if (mysqlType.equalsIgnoreCase("ENUM")) {
            return 1;
        }
        if (mysqlType.equalsIgnoreCase("SET")) {
            return 1;
        }
        return 1111;
    }

    static {
        SLEEP = 0;
        QUIT = 1;
        INIT_DB = 2;
        QUERY = 3;
        FIELD_LIST = 4;
        CREATE_DB = 5;
        DROP_DB = 6;
        RELOAD = 7;
        SHUTDOWN = 8;
        STATISTICS = 9;
        PROCESS_INFO = 10;
        CONNECT = 11;
        PROCESS_KILL = 12;
        DEBUG = 13;
        PING = 14;
        TIME = 15;
        DELAYED_INSERT = 16;
        CHANGE_USER = 17;
        COM_BINLOG_DUMP = 18;
        COM_TABLE_DUMP = 19;
        COM_CONNECT_OUT = 20;
        COM_REGISTER_SLAVE = 21;
        COM_PREPARE = 22;
        COM_EXECUTE = 23;
        COM_LONG_DATA = 24;
        FIELD_TYPE_DECIMAL = 0;
        FIELD_TYPE_TINY = 1;
        FIELD_TYPE_SHORT = 2;
        FIELD_TYPE_LONG = 3;
        FIELD_TYPE_FLOAT = 4;
        FIELD_TYPE_DOUBLE = 5;
        FIELD_TYPE_NULL = 6;
        FIELD_TYPE_TIMESTAMP = 7;
        FIELD_TYPE_LONGLONG = 8;
        FIELD_TYPE_INT24 = 9;
        FIELD_TYPE_DATE = 10;
        FIELD_TYPE_TIME = 11;
        FIELD_TYPE_DATETIME = 12;
        FIELD_TYPE_YEAR = 13;
        FIELD_TYPE_NEWDATE = 14;
        FIELD_TYPE_ENUM = 247;
        FIELD_TYPE_SET = 248;
        FIELD_TYPE_TINY_BLOB = 249;
        FIELD_TYPE_MEDIUM_BLOB = 250;
        FIELD_TYPE_LONG_BLOB = 251;
        FIELD_TYPE_BLOB = 252;
        FIELD_TYPE_VAR_STRING = 253;
        FIELD_TYPE_STRING = 254;
        ER_WARNING_NOT_COMPLETE_ROLLBACK = 1196;
        MAX_ROWS = 50000000;
    }
}

