#ifndef _LIST_H_
#define _LIST_H_

struct ListNode {
	int data;
	ListNode *next;
	ListNode *prev;
};

struct DList {
	ListNode *head;
};

void createList(DList &l);
ListNode* first(DList &l);
void insertHead(DList &l, int data);
void insertAfter(ListNode* node, int data);
void printData(DList &l);
bool find(DList &l, int data);
void deleteHead(DList &l);
void deleteAfter(ListNode* node);
void deleteData(DList &l, int data);
void deleteList(DList &l);

// New functions
/* Inserts a new node with provided data before the specified node */
void insertBefore(DList &l, ListNode* node, int data);
/* Deletes the specified node */
void deleteNode(DList &l, ListNode* node);


#endif //_LIST_H_
