#ifndef _POLI_H_
#define _POLI_H_

#include <iostream>
using namespace std;


class Polynomial
{
	private:
		/* Member variables */
		int a, b, c;
		/* Static member variable */
		static int numPolynomials;
		
	public:
		/* Constructors */
		Polynomial();
		Polynomial(int a, int b, int c);
		Polynomial(const Polynomial &p); // Copy constructor
		
		/* Destructor */
		~Polynomial();
		
		/* Member functions */
		bool hasRealSolution();
		double getRealSolution1();
		double getRealSolution2();
		
		/* Overloaded operators */
		Polynomial& operator=(const Polynomial &p);
		
		Polynomial  operator+(const Polynomial &p);
		bool        operator==(const Polynomial &p);
		
		int operator()(int x);
		
		/* Friends */
		friend ostream& operator<<(ostream &os, const Polynomial &p);
		
		/* Static member function */
		static int getNumPolynomials();
};

#endif //_POLI_H_
