/*
 * This program loads a grayscale image from "input.pgm", and draws
 * white lines across it.  The output is saved to "output.pgm".
 */

#include "image.h"
#include "pnmfile.h"

int main() {
  // load image
  image<uchar> *input = loadPGM("input.pgm");
  int width = input->width();
  int height = input->height();

  // draw horizontal lines
  for (int y = 0; y < height; y += 10) {
    for (int x = 0; x < width; x++) {
      imRef(input, x, y) = 255;
    }
  }

  // save image & free memory
  savePGM(input, "output.pgm");
  delete input;
}
