/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.TimeUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    private static final SimpleDateFormat TSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DatabaseMetaData dbmd = null;
    private String originalSql = null;
    private boolean[] isNull = null;
    private boolean[] isStream = null;
    private InputStream[] parameterStreams = null;
    private byte[][] parameterValues = null;
    private byte[][] staticSqlStrings = null;
    private byte[] streamConvertBuf = new byte[4096];
    private int[] streamLengths = null;
    private boolean hasLimitClause = false;
    private boolean useTrueBoolean = false;
    private char firstCharOfStmt = '\u0000';

    public PreparedStatement(Connection conn, String sql, String catalog) throws SQLException {
        super(conn, catalog);
        if (sql == null) {
            throw new SQLException("SQL String can not be NULL", "S1009");
        }
        this.dbmd = this.connection.getMetaData();
        String quotedIdentifierString = this.dbmd.getIdentifierQuoteString();
        char quotedIdentifierChar = '\u0000';
        if (quotedIdentifierString != null && !quotedIdentifierString.equals(" ") && quotedIdentifierString.length() > 0) {
            quotedIdentifierChar = quotedIdentifierString.charAt(0);
        }
        if (this.connection.useTimezone()) {
            TSDF.setTimeZone(this.connection.getServerTimezone());
        }
        this.useTrueBoolean = this.connection.getIO().versionMeetsMinimum(3, 21, 23);
        this.hasLimitClause = sql.toUpperCase().indexOf("LIMIT") != -1;
        char[] statementAsChars = sql.toCharArray();
        int statementLength = statementAsChars.length;
        int placeHolderCount = 0;
        int i = 0;
        while (i < statementLength) {
            if (statementAsChars[i] == '?') {
                ++placeHolderCount;
            }
            if (this.firstCharOfStmt == '\u0000' && !Character.isWhitespace(statementAsChars[i])) {
                this.firstCharOfStmt = Character.toUpperCase(statementAsChars[i]);
            }
            ++i;
        }
        ArrayList<EndPoint> endpointList = new ArrayList<EndPoint>(placeHolderCount + 1);
        boolean inQuotes = false;
        boolean inQuotedId = false;
        int lastParmEnd = 0;
        this.originalSql = sql;
        this.connection = conn;
        char pre1 = '\u0000';
        char pre2 = '\u0000';
        int i2 = 0;
        while (i2 < statementLength) {
            char c = statementAsChars[i2];
            if (quotedIdentifierChar != '\u0000' && c == quotedIdentifierChar) {
                boolean bl = inQuotedId = !inQuotedId;
            }
            if (!inQuotedId) {
                if (c == '\'' && pre1 == '\\' && pre2 == '\\') {
                    inQuotes = !inQuotes;
                } else if (c == '\'' && pre1 != '\\') {
                    boolean bl = inQuotes = !inQuotes;
                }
            }
            if (c == '?' && !inQuotes) {
                endpointList.add(new EndPoint(lastParmEnd, i2));
                lastParmEnd = i2 + 1;
            }
            pre2 = pre1;
            pre1 = c;
            ++i2;
        }
        endpointList.add(new EndPoint(lastParmEnd, statementLength));
        this.staticSqlStrings = new byte[endpointList.size()][];
        i2 = 0;
        while (i2 < this.staticSqlStrings.length) {
            int len;
            int begin;
            int end;
            EndPoint ep;
            if (this.charEncoding == null) {
                ep = (EndPoint)endpointList.get(i2);
                end = ep.end;
                begin = ep.begin;
                len = end - begin;
                byte[] buf = new byte[len];
                int j = 0;
                while (j < len) {
                    buf[j] = (byte)statementAsChars[begin + j];
                    ++j;
                }
                this.staticSqlStrings[i2] = buf;
            } else {
                try {
                    ep = (EndPoint)endpointList.get(i2);
                    end = ep.end;
                    begin = ep.begin;
                    len = end - begin;
                    String temp = new String(statementAsChars, begin, len);
                    this.staticSqlStrings[i2] = StringUtils.getBytes(temp, this.charEncoding);
                }
                catch (UnsupportedEncodingException ue) {
                    throw new SQLException(ue.toString());
                }
            }
            ++i2;
        }
        int numberOfParameters = this.staticSqlStrings.length - 1;
        this.parameterValues = new byte[numberOfParameters][];
        this.parameterStreams = new InputStream[numberOfParameters];
        this.isStream = new boolean[numberOfParameters];
        this.streamLengths = new int[numberOfParameters];
        this.isNull = new boolean[numberOfParameters];
        this.clearParameters();
        int j = 0;
        while (j < numberOfParameters) {
            this.isStream[j] = false;
            ++j;
        }
    }

    public void setArray(int i, Array x) throws SQLException {
        throw new NotImplemented();
    }

    public synchronized void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
        } else {
            this.setBinaryStream(parameterIndex, x, length);
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.setInternal(parameterIndex, PreparedStatement.fixDecimalExponent(x.toString()));
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            if (parameterIndex < 1 || parameterIndex > this.staticSqlStrings.length) {
                throw new SQLException("Parameter index out of range (" + parameterIndex + " > " + this.staticSqlStrings.length + ")", "S1009");
            }
            this.parameterStreams[parameterIndex - 1] = x;
            this.isStream[parameterIndex - 1] = true;
            this.streamLengths[parameterIndex - 1] = length;
            this.isNull[parameterIndex - 1] = false;
        }
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.setBinaryStream(i, x.getBinaryStream(), Integer.MAX_VALUE);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (this.useTrueBoolean) {
            this.setInternal(parameterIndex, x ? "'1'" : "'0'");
        } else {
            this.setInternal(parameterIndex, x ? "'t'" : "'f'");
        }
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setInternal(parameterIndex, String.valueOf(x));
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            int numBytes = x.length;
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(numBytes);
            bOut.write(39);
            int i = 0;
            while (i < numBytes) {
                byte b = x[i];
                switch (b) {
                    case 0: {
                        bOut.write(92);
                        bOut.write(48);
                        break;
                    }
                    case 10: {
                        bOut.write(92);
                        bOut.write(110);
                        break;
                    }
                    case 13: {
                        bOut.write(92);
                        bOut.write(114);
                        break;
                    }
                    case 92: {
                        bOut.write(92);
                        bOut.write(92);
                        break;
                    }
                    case 39: {
                        bOut.write(92);
                        bOut.write(39);
                        break;
                    }
                    case 34: {
                        bOut.write(92);
                        bOut.write(34);
                        break;
                    }
                    case 26: {
                        bOut.write(92);
                        bOut.write(90);
                        break;
                    }
                    default: {
                        bOut.write(b);
                    }
                }
                ++i;
            }
            bOut.write(39);
            this.setInternal(parameterIndex, bOut.toByteArray());
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            if (reader == null) {
                this.setNull(parameterIndex, -1);
            } else {
                char[] c = null;
                int len = 0;
                boolean useLength = this.connection.useStreamLengthsInPrepStmts();
                if (useLength && length != -1) {
                    c = new char[length];
                    int numCharsRead = PreparedStatement.readFully(reader, c, length);
                    this.setString(parameterIndex, new String(c, 0, numCharsRead));
                } else {
                    c = new char[4096];
                    StringBuffer buf = new StringBuffer();
                    while ((len = reader.read(c)) != -1) {
                        buf.append(c, 0, len);
                    }
                    this.setString(parameterIndex, buf.toString());
                }
            }
        }
        catch (IOException ioEx) {
            throw new SQLException(ioEx.toString(), "S1000");
        }
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.setString(i, x.getSubString(0L, (int)x.length()));
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 91);
        } else {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("''yyyy-MM-dd''");
            this.setInternal(parameterIndex, dateFormatter.format(x));
        }
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setDate(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setInternal(parameterIndex, PreparedStatement.fixDecimalExponent(String.valueOf(x)));
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setInternal(parameterIndex, PreparedStatement.fixDecimalExponent(String.valueOf(x)));
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setInternal(parameterIndex, String.valueOf(x));
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setInternal(parameterIndex, String.valueOf(x));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw new NotImplemented();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setInternal(parameterIndex, "null");
        this.isNull[parameterIndex - 1] = true;
    }

    public void setNull(int parameterIndex, int sqlType, String arg) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    public void setObject(int parameterIndex, Object parameterObj, int targetSqlType, int scale) throws SQLException {
        if (parameterObj == null) {
            this.setNull(parameterIndex, 1111);
        } else {
            try {
                block1 : switch (targetSqlType) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        Number parameterAsNum;
                        if (parameterObj instanceof Boolean) {
                            parameterAsNum = (Boolean)parameterObj != false ? new Integer(1) : new Integer(0);
                        } else if (parameterObj instanceof String) {
                            switch (targetSqlType) {
                                case -7: {
                                    parameterAsNum = Boolean.getBoolean((String)parameterObj) ? new Integer("1") : new Integer("0");
                                    break;
                                }
                                case -6: 
                                case 4: 
                                case 5: {
                                    parameterAsNum = Integer.valueOf((String)parameterObj);
                                    break;
                                }
                                case -5: {
                                    parameterAsNum = Long.valueOf((String)parameterObj);
                                    break;
                                }
                                case 7: {
                                    parameterAsNum = Float.valueOf((String)parameterObj);
                                    break;
                                }
                                case 6: 
                                case 8: {
                                    parameterAsNum = Double.valueOf((String)parameterObj);
                                    break;
                                }
                                default: {
                                    parameterAsNum = new BigDecimal((String)parameterObj);
                                    break;
                                }
                            }
                        } else {
                            parameterAsNum = (Number)parameterObj;
                        }
                        switch (targetSqlType) {
                            case -7: 
                            case -6: 
                            case 4: 
                            case 5: {
                                this.setInt(parameterIndex, parameterAsNum.intValue());
                                break block1;
                            }
                            case -5: {
                                this.setLong(parameterIndex, parameterAsNum.longValue());
                                break block1;
                            }
                            case 7: {
                                this.setFloat(parameterIndex, parameterAsNum.floatValue());
                                break block1;
                            }
                            case 6: 
                            case 8: {
                                this.setDouble(parameterIndex, parameterAsNum.doubleValue());
                                break block1;
                            }
                        }
                        if (parameterAsNum instanceof BigDecimal) {
                            this.setBigDecimal(parameterIndex, (BigDecimal)parameterAsNum);
                            break;
                        }
                        if (parameterAsNum instanceof BigInteger) {
                            this.setBigDecimal(parameterIndex, new BigDecimal((BigInteger)parameterAsNum, scale));
                            break;
                        }
                        this.setBigDecimal(parameterIndex, new BigDecimal(parameterAsNum.doubleValue()));
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        this.setString(parameterIndex, parameterObj.toString());
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        if (parameterObj instanceof String) {
                            this.setBytes(parameterIndex, StringUtils.getBytes((String)parameterObj, this.charConverter, this.charEncoding));
                            break;
                        }
                        this.setBytes(parameterIndex, (byte[])parameterObj);
                        break;
                    }
                    case 91: 
                    case 93: {
                        java.util.Date parameterAsDate;
                        if (parameterObj instanceof String) {
                            ParsePosition pp = new ParsePosition(0);
                            SimpleDateFormat sdf = new SimpleDateFormat(this.getDateTimePattern((String)parameterObj, false));
                            parameterAsDate = ((DateFormat)sdf).parse((String)parameterObj, pp);
                        } else {
                            parameterAsDate = (java.util.Date)parameterObj;
                        }
                        switch (targetSqlType) {
                            case 91: {
                                if (parameterAsDate instanceof Date) {
                                    this.setDate(parameterIndex, (Date)parameterAsDate);
                                    break block1;
                                }
                                this.setDate(parameterIndex, new Date(parameterAsDate.getTime()));
                                break block1;
                            }
                            case 93: {
                                if (parameterAsDate instanceof Timestamp) {
                                    this.setTimestamp(parameterIndex, (Timestamp)parameterAsDate);
                                    break block1;
                                }
                                this.setTimestamp(parameterIndex, new Timestamp(parameterAsDate.getTime()));
                            }
                        }
                        break;
                    }
                    case 92: {
                        if (parameterObj instanceof String) {
                            SimpleDateFormat sdf = new SimpleDateFormat(this.getDateTimePattern((String)parameterObj, true));
                            this.setTime(parameterIndex, new Time(sdf.parse((String)parameterObj).getTime()));
                            break;
                        }
                        if (parameterObj instanceof Timestamp) {
                            Timestamp xT = (Timestamp)parameterObj;
                            this.setTime(parameterIndex, new Time(xT.getHours(), xT.getMinutes(), xT.getSeconds()));
                            break;
                        }
                        this.setTime(parameterIndex, (Time)parameterObj);
                        break;
                    }
                    case 1111: {
                        this.setSerializableObject(parameterIndex, parameterObj);
                        break;
                    }
                    default: {
                        throw new SQLException("Unknown Types value", "S1000");
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                throw new SQLException("Cannot convert " + parameterObj.getClass().toString() + " to SQL type requested due to " + ex.getClass().getName() + " - " + ex.getMessage(), "S1000");
            }
        }
    }

    public void setObject(int parameterIndex, Object parameterObj, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, parameterObj, targetSqlType, 0);
    }

    public void setObject(int parameterIndex, Object parameterObj) throws SQLException {
        if (parameterObj == null) {
            this.setNull(parameterIndex, 1111);
        } else if (parameterObj instanceof Byte) {
            this.setInt(parameterIndex, ((Byte)parameterObj).intValue());
        } else if (parameterObj instanceof String) {
            this.setString(parameterIndex, (String)parameterObj);
        } else if (parameterObj instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)parameterObj);
        } else if (parameterObj instanceof Short) {
            this.setShort(parameterIndex, (Short)parameterObj);
        } else if (parameterObj instanceof Integer) {
            this.setInt(parameterIndex, (Integer)parameterObj);
        } else if (parameterObj instanceof Long) {
            this.setLong(parameterIndex, (Long)parameterObj);
        } else if (parameterObj instanceof Float) {
            this.setFloat(parameterIndex, ((Float)parameterObj).floatValue());
        } else if (parameterObj instanceof Double) {
            this.setDouble(parameterIndex, (Double)parameterObj);
        } else if (parameterObj instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])parameterObj);
        } else if (parameterObj instanceof Date) {
            this.setDate(parameterIndex, (Date)parameterObj);
        } else if (parameterObj instanceof Time) {
            this.setTime(parameterIndex, (Time)parameterObj);
        } else if (parameterObj instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)parameterObj);
        } else if (parameterObj instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)parameterObj);
        } else if (parameterObj instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)parameterObj, -1);
        } else if (parameterObj instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)parameterObj);
        } else if (parameterObj instanceof Clob) {
            this.setClob(parameterIndex, (Clob)parameterObj);
        } else {
            this.setSerializableObject(parameterIndex, parameterObj);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new NotImplemented();
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw new NotImplemented();
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setInternal(parameterIndex, String.valueOf(x));
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        if (x == null) {
            try {
                this.setInternal(parameterIndex, StringUtils.getBytes("null", this.charConverter, this.charEncoding));
            }
            catch (UnsupportedEncodingException uue) {
                throw new SQLException("Unsupported character encoding '" + this.charEncoding + "'", "S1009");
            }
        }
        StringBuffer buf = new StringBuffer((int)((double)x.length() * 1.1));
        buf.append('\'');
        int stringLength = x.length();
        int i = 0;
        while (i < stringLength) {
            char c = x.charAt(i);
            switch (c) {
                case '\u0000': {
                    buf.append('\\');
                    buf.append('0');
                    break;
                }
                case '\n': {
                    buf.append('\\');
                    buf.append('n');
                    break;
                }
                case '\r': {
                    buf.append('\\');
                    buf.append('r');
                    break;
                }
                case '\\': {
                    buf.append('\\');
                    buf.append('\\');
                    break;
                }
                case '\'': {
                    buf.append('\\');
                    buf.append('\'');
                    break;
                }
                case '\"': {
                    buf.append('\\');
                    buf.append('\"');
                    break;
                }
                case '\u001a': {
                    buf.append('\\');
                    buf.append('Z');
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        buf.append('\'');
        String parameterAsString = buf.toString();
        try {
            byte[] parameterAsBytes = StringUtils.getBytes(parameterAsString, this.charConverter, this.charEncoding);
            this.setInternal(parameterIndex, parameterAsBytes);
        }
        catch (UnsupportedEncodingException uue) {
            throw new SQLException("Unsupported character encoding '" + this.charEncoding + "'", "S1009");
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTimeInternal(parameterIndex, x, TimeZone.getDefault());
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setTimeInternal(parameterIndex, x, cal.getTimeZone());
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestampInternal(parameterIndex, x, TimeZone.getDefault());
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestampInternal(parameterIndex, x, cal.getTimeZone());
    }

    public void setURL(int parameterIndex, URL arg) throws SQLException {
        if (arg != null) {
            this.setString(parameterIndex, arg.toString());
        } else {
            this.setNull(parameterIndex, 1);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
        } else {
            this.setBinaryStream(parameterIndex, x, length);
        }
    }

    public void addBatch() throws SQLException {
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList();
        }
        this.batchedArgs.add(new BatchParams(this.parameterValues, this.parameterStreams, this.isStream, this.streamLengths, this.isNull));
    }

    public void clearParameters() throws SQLException {
        int i = 0;
        while (i < this.parameterValues.length) {
            this.parameterValues[i] = null;
            this.parameterStreams[i] = null;
            this.isStream[i] = false;
            this.isNull[i] = false;
            ++i;
        }
    }

    public void close() throws SQLException {
        super.close();
        this.dbmd = null;
        this.originalSql = null;
        this.staticSqlStrings = null;
        this.parameterValues = null;
        this.parameterStreams = null;
        this.isStream = null;
        this.streamLengths = null;
        this.isNull = null;
        this.streamConvertBuf = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        if (this.connection.isReadOnly() && this.firstCharOfStmt != 'S') {
            throw new SQLException("Connection is read-only. Queries leading to data modification are not allowed", "S1009");
        }
        this.checkClosed();
        ResultSet rs = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            Buffer sendPacket = this.fillSendPacket();
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.useMaxRows()) {
                if (this.firstCharOfStmt == 'S') {
                    if (this.hasLimitClause) {
                        rs = this.connection.execSQL(null, this.maxRows, sendPacket, this.resultSetConcurrency, this.createStreamingResultSet(), true, this.currentCatalog);
                    } else if (this.maxRows <= 0) {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, this.currentCatalog);
                    } else {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this.maxRows, -1, this.currentCatalog);
                    }
                } else {
                    this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, this.currentCatalog);
                }
                rs = this.connection.execSQL(null, -1, sendPacket, this.resultSetConcurrency, this.createStreamingResultSet(), this.firstCharOfStmt == 'S', this.currentCatalog);
            } else {
                rs = this.connection.execSQL(null, -1, sendPacket, this.resultSetConcurrency, this.createStreamingResultSet(), this.firstCharOfStmt == 'S', this.currentCatalog);
            }
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        this.lastInsertId = rs.getUpdateID();
        if (rs != null) {
            this.results = rs;
        }
        rs.setConnection(this.connection);
        rs.setResultSetType(this.resultSetType);
        rs.setResultSetConcurrency(this.resultSetConcurrency);
        rs.setStatement(this);
        return rs != null && rs.reallyResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        if (this.connection.isReadOnly()) {
            throw new SQLException("Connection is read-only. Queries leading to data modification are not allowed", "S1009");
        }
        try {
            int[] updateCounts = null;
            if (this.batchedArgs != null) {
                int nbrCommands = this.batchedArgs.size();
                updateCounts = new int[nbrCommands];
                int i = 0;
                while (i < nbrCommands) {
                    updateCounts[i] = -3;
                    ++i;
                }
                Throwable sqlEx = null;
                int commandIndex = 0;
                commandIndex = 0;
                while (commandIndex < nbrCommands) {
                    Object arg = this.batchedArgs.get(commandIndex);
                    if (arg instanceof String) {
                        updateCounts[commandIndex] = this.executeUpdate((String)arg);
                    } else {
                        BatchParams paramArg = (BatchParams)arg;
                        try {
                            updateCounts[commandIndex] = this.executeUpdate(paramArg.parameterStrings, paramArg.parameterStreams, paramArg.isStream, paramArg.streamLengths, paramArg.isNull);
                        }
                        catch (SQLException ex) {
                            updateCounts[commandIndex] = -3;
                            if (this.connection.continueBatchOnError()) {
                                sqlEx = ex;
                            }
                            int[] newUpdateCounts = new int[commandIndex];
                            System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                            throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                        }
                    }
                    ++commandIndex;
                }
                if (sqlEx != null) {
                    throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
                }
            }
            nArray = updateCounts != null ? updateCounts : new int[]{};
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.clearBatch();
            throw throwable;
        }
        this.clearBatch();
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized java.sql.ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        if ((this.firstCharOfStmt == 'I' || this.firstCharOfStmt == 'U' || this.firstCharOfStmt == 'D' || this.firstCharOfStmt == 'A' || this.firstCharOfStmt == 'C') && (StringUtils.startsWithIgnoreCaseAndWs(this.originalSql, "INSERT") || StringUtils.startsWithIgnoreCaseAndWs(this.originalSql, "UPDATE") || StringUtils.startsWithIgnoreCaseAndWs(this.originalSql, "DELETE") || StringUtils.startsWithIgnoreCaseAndWs(this.originalSql, "DROP") || StringUtils.startsWithIgnoreCaseAndWs(this.originalSql, "CREATE") || StringUtils.startsWithIgnoreCaseAndWs(this.originalSql, "ALTER"))) {
            throw new SQLException("Can not issue data manipulation statements with executeQuery()", "S1009");
        }
        Object object = this.connection.getMutex();
        synchronized (object) {
            Buffer sendPacket = this.fillSendPacket();
            if (this.results != null) {
                this.results.close();
            }
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.useMaxRows()) {
                if (this.hasLimitClause) {
                    this.results = this.connection.execSQL(null, this.maxRows, sendPacket, this.resultSetConcurrency, this.createStreamingResultSet(), true, this.currentCatalog);
                } else {
                    if (this.maxRows <= 0) {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, this.currentCatalog);
                    } else {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this.maxRows, -1, this.currentCatalog);
                    }
                    this.results = this.connection.execSQL(null, -1, sendPacket, this.resultSetConcurrency, this.createStreamingResultSet(), true, this.currentCatalog);
                    if (oldCatalog != null) {
                        this.connection.setCatalog(oldCatalog);
                    }
                }
            } else {
                this.results = this.connection.execSQL(null, -1, sendPacket, this.resultSetConcurrency, this.createStreamingResultSet(), true, this.currentCatalog);
            }
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        this.lastInsertId = this.results.getUpdateID();
        this.nextResults = this.results;
        this.results.setConnection(this.connection);
        this.results.setResultSetType(this.resultSetType);
        this.results.setResultSetConcurrency(this.resultSetConcurrency);
        this.results.setStatement(this);
        return this.results;
    }

    public synchronized int executeUpdate() throws SQLException {
        return this.executeUpdate(this.parameterValues, this.parameterStreams, this.isStream, this.streamLengths, this.isNull);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append(": ");
        try {
            int i = 0;
            while (i < this.parameterValues.length) {
                if (this.charEncoding != null) {
                    buf.append(new String(this.staticSqlStrings[i], this.charEncoding));
                } else {
                    buf.append(new String(this.staticSqlStrings[i]));
                }
                if (this.parameterValues[i] == null && !this.isStream[i]) {
                    buf.append("** NOT SPECIFIED **");
                } else if (this.isStream[i]) {
                    buf.append("** STREAM DATA **");
                } else if (this.charConverter != null) {
                    buf.append(this.charConverter.toString(this.parameterValues[i]));
                } else if (this.charEncoding != null) {
                    buf.append(new String(this.parameterValues[i], this.charEncoding));
                } else {
                    buf.append(StringUtils.toAsciiString(this.parameterValues[i]));
                }
                ++i;
            }
            if (this.charEncoding != null) {
                buf.append(new String(this.staticSqlStrings[this.parameterValues.length], this.charEncoding));
            } else {
                buf.append(this.staticSqlStrings[this.parameterValues.length]);
            }
        }
        catch (UnsupportedEncodingException uue) {
            throw new RuntimeException("Unsupported character encoding '" + this.charEncoding + "'");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int executeUpdate(byte[][] batchedParameterStrings, InputStream[] batchedParameterStreams, boolean[] batchedIsStream, int[] batchedStreamLengths, boolean[] batchedIsNull) throws SQLException {
        if (this.connection.isReadOnly()) {
            throw new SQLException("Connection is read-only. Queries leading to data modification are not allowed", "S1009");
        }
        this.checkClosed();
        if (this.firstCharOfStmt == 'S' && StringUtils.startsWithIgnoreCaseAndWs(this.originalSql, "SELECT")) {
            throw new SQLException("Can not issue executeUpdate() for SELECTs", "S1009");
        }
        ResultSet rs = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            Buffer sendPacket = this.fillSendPacket(batchedParameterStrings, batchedParameterStreams, batchedIsStream, batchedStreamLengths);
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.useMaxRows()) {
                this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, this.currentCatalog);
            }
            rs = this.connection.execSQL(null, -1, sendPacket, this.resultSetConcurrency, false, false, this.currentCatalog);
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        this.updateCount = rs.getUpdateCount();
        int truncatedUpdateCount = 0;
        truncatedUpdateCount = this.updateCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.updateCount;
        this.lastInsertId = rs.getUpdateID();
        return truncatedUpdateCount;
    }

    byte[] getBytes(int parameterIndex) throws SQLException {
        if (this.isStream[parameterIndex]) {
            return this.streamToBytes(this.parameterStreams[parameterIndex], false, this.streamLengths[parameterIndex], this.connection.useStreamLengthsInPrepStmts());
        }
        byte[] parameterVal = this.parameterValues[parameterIndex];
        if (parameterVal == null) {
            return null;
        }
        if (parameterVal[0] == 39 && parameterVal[parameterVal.length - 1] == 39) {
            byte[] valNoQuotes = new byte[parameterVal.length - 2];
            System.arraycopy(parameterVal, 1, valNoQuotes, 0, parameterVal.length - 2);
            return valNoQuotes;
        }
        return parameterVal;
    }

    boolean isNull(int paramIndex) {
        return this.isNull[paramIndex];
    }

    void setResultSetConcurrency(int concurrencyFlag) {
        this.resultSetConcurrency = concurrencyFlag;
    }

    void setResultSetType(int typeFlag) {
        this.resultSetType = typeFlag;
    }

    private final String getDateTimePattern(String dt, boolean toTime) throws Exception {
        int i;
        int size;
        char c;
        int n;
        Object[] v;
        int z;
        char c2;
        int dtLength;
        int n2 = dtLength = dt != null ? dt.length() : 0;
        if (dtLength >= 8 && dtLength <= 10) {
            int dashCount = 0;
            boolean isDateOnly = true;
            int i2 = 0;
            while (i2 < dtLength) {
                c2 = dt.charAt(i2);
                if (!Character.isDigit(c2) && c2 != '-') {
                    isDateOnly = false;
                    break;
                }
                if (c2 == '-') {
                    ++dashCount;
                }
                ++i2;
            }
            if (isDateOnly && dashCount == 2) {
                return "yyyy-MM-dd";
            }
        }
        boolean colonsOnly = true;
        int i3 = 0;
        while (i3 < dtLength) {
            char c3 = dt.charAt(i3);
            if (!Character.isDigit(c3) && c3 != ':') {
                colonsOnly = false;
                break;
            }
            ++i3;
        }
        if (colonsOnly) {
            return "HH:mm:ss";
        }
        StringReader reader = new StringReader(dt + " ");
        ArrayList<Object[]> vec = new ArrayList<Object[]>();
        ArrayList<Object[]> vecRemovelist = new ArrayList<Object[]>();
        Object[] nv = new Object[]{new Character('y'), new StringBuffer(), new Integer(0)};
        vec.add(nv);
        if (toTime) {
            nv = new Object[]{new Character('h'), new StringBuffer(), new Integer(0)};
            vec.add(nv);
        }
        while ((z = reader.read()) != -1) {
            char separator = c2;
            int maxvecs = vec.size();
            int count = 0;
            while (count < maxvecs) {
                v = (Object[])vec.get(count);
                n = (Integer)v[2];
                c = this.getSuccessor(((Character)v[0]).charValue(), n);
                if (!Character.isLetterOrDigit(separator)) {
                    if (c == ((Character)v[0]).charValue() && c != 'S') {
                        vecRemovelist.add(v);
                    } else {
                        ((StringBuffer)v[1]).append(separator);
                        if (c == 'X' || c == 'Y') {
                            v[2] = new Integer(4);
                        }
                    }
                } else {
                    if (c == 'X') {
                        c = 'y';
                        nv = new Object[3];
                        nv[1] = new StringBuffer(((StringBuffer)v[1]).toString()).append('M');
                        nv[0] = new Character('M');
                        nv[2] = new Integer(1);
                        vec.add(nv);
                    } else if (c == 'Y') {
                        c = 'M';
                        nv = new Object[3];
                        nv[1] = new StringBuffer(((StringBuffer)v[1]).toString()).append('d');
                        nv[0] = new Character('d');
                        nv[2] = new Integer(1);
                        vec.add(nv);
                    }
                    ((StringBuffer)v[1]).append(c);
                    if (c == ((Character)v[0]).charValue()) {
                        v[2] = new Integer(n + 1);
                    } else {
                        v[0] = new Character(c);
                        v[2] = new Integer(1);
                    }
                }
                ++count;
            }
            size = vecRemovelist.size();
            i = 0;
            while (i < size) {
                v = (Object[])vecRemovelist.get(i);
                vec.remove(v);
                ++i;
            }
            vecRemovelist.clear();
        }
        size = vec.size();
        i = 0;
        while (i < size) {
            boolean containsEnd;
            v = (Object[])vec.get(i);
            c = ((Character)v[0]).charValue();
            boolean bk = this.getSuccessor(c, n = ((Integer)v[2]).intValue()) != c;
            boolean atEnd = (c == 's' || c == 'm' || c == 'h' && toTime) && bk;
            boolean finishesAtDate = bk && c == 'd' && !toTime;
            boolean bl = containsEnd = ((StringBuffer)v[1]).toString().indexOf(87) != -1;
            if (!atEnd && !finishesAtDate || containsEnd) {
                vecRemovelist.add(v);
            }
            ++i;
        }
        size = vecRemovelist.size();
        int i4 = 0;
        while (i4 < size) {
            vec.remove(vecRemovelist.get(i4));
            ++i4;
        }
        vecRemovelist.clear();
        v = (Object[])vec.get(0);
        StringBuffer format = (StringBuffer)v[1];
        format.setLength(format.length() - 1);
        return format.toString();
    }

    private final void setInternal(int paramIndex, byte[] val) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.staticSqlStrings.length) {
            throw new SQLException("Parameter index out of range (" + paramIndex + " > " + this.staticSqlStrings.length + ").", "S1009");
        }
        if (this.isClosed) {
            throw new SQLException("PreparedStatement has been closed. No further operations allowed.", "S1009");
        }
        this.isStream[paramIndex - 1] = false;
        this.isNull[paramIndex - 1] = false;
        this.parameterStreams[paramIndex - 1] = null;
        this.parameterValues[paramIndex - 1] = val;
    }

    private final void setInternal(int paramIndex, String val) throws SQLException {
        byte[] parameterAsBytes = null;
        if (this.charConverter != null) {
            parameterAsBytes = this.charConverter.toBytes(val);
        } else {
            try {
                parameterAsBytes = StringUtils.getBytes(val, this.charConverter, this.charEncoding);
            }
            catch (UnsupportedEncodingException uEE) {
                throw new SQLException("Unsupported encoding '" + this.charEncoding + "'", "S1009");
            }
        }
        this.setInternal(paramIndex, parameterAsBytes);
    }

    private final void setSerializableObject(int parameterIndex, Object parameterObj) throws SQLException {
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(bytesOut);
            objectOut.writeObject(parameterObj);
            objectOut.flush();
            objectOut.close();
            bytesOut.flush();
            bytesOut.close();
            byte[] buf = bytesOut.toByteArray();
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(buf);
            this.setBinaryStream(parameterIndex, (InputStream)bytesIn, buf.length);
        }
        catch (Exception ex) {
            throw new SQLException("Invalid argument value: " + ex.getClass().getName(), "S1009");
        }
    }

    private final char getSuccessor(char c, int n) {
        return (char)(c == 'y' && n == 2 ? 88 : (c == 'y' && n < 4 ? 121 : (c == 'y' ? 77 : (c == 'M' && n == 2 ? 89 : (c == 'M' && n < 3 ? 77 : (c == 'M' ? 100 : (c == 'd' && n < 2 ? 100 : (c == 'd' ? 72 : (c == 'H' && n < 2 ? 72 : (c == 'H' ? 109 : (c == 'm' && n < 2 ? 109 : (c == 'm' ? 115 : (c == 's' && n < 2 ? 115 : 87)))))))))))));
    }

    private void setTimeInternal(int parameterIndex, Time x, TimeZone tz) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 92);
        } else {
            x = TimeUtil.changeTimezone(this.connection, x, tz, this.connection.getServerTimezone());
            this.setInternal(parameterIndex, "'" + x.toString() + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimestampInternal(int parameterIndex, Timestamp x, TimeZone tz) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 93);
        } else {
            String timestampString = null;
            x = TimeUtil.changeTimezone(this.connection, x, tz, this.connection.getServerTimezone());
            SimpleDateFormat simpleDateFormat = TSDF;
            synchronized (simpleDateFormat) {
                timestampString = "'" + TSDF.format(x) + "'";
            }
            this.setInternal(parameterIndex, timestampString);
        }
    }

    private Buffer fillSendPacket() throws SQLException {
        return this.fillSendPacket(this.parameterValues, this.parameterStreams, this.isStream, this.streamLengths);
    }

    private Buffer fillSendPacket(byte[][] batchedParameterStrings, InputStream[] batchedParameterStreams, boolean[] batchedIsStream, int[] batchedStreamLengths) throws SQLException {
        Buffer sendPacket = this.connection.getIO().getSharedSendPacket();
        sendPacket.clear();
        sendPacket.writeByte((byte)3);
        boolean useStreamLengths = this.connection.useStreamLengthsInPrepStmts();
        int ensurePacketSize = 0;
        int i = 0;
        while (i < batchedParameterStrings.length) {
            if (batchedIsStream[i] && useStreamLengths) {
                ensurePacketSize += batchedStreamLengths[i];
            }
            ++i;
        }
        if (ensurePacketSize != 0) {
            sendPacket.ensureCapacity(ensurePacketSize);
        }
        int i2 = 0;
        while (i2 < batchedParameterStrings.length) {
            if (batchedParameterStrings[i2] == null && batchedParameterStreams[i2] == null) {
                throw new SQLException("No value specified for parameter " + (i2 + 1), "07001");
            }
            sendPacket.writeBytesNoNull(this.staticSqlStrings[i2]);
            if (batchedIsStream[i2]) {
                this.streamToBytes(sendPacket, batchedParameterStreams[i2], true, batchedStreamLengths[i2], useStreamLengths);
            } else {
                sendPacket.writeBytesNoNull(batchedParameterStrings[i2]);
            }
            ++i2;
        }
        sendPacket.writeBytesNoNull(this.staticSqlStrings[batchedParameterStrings.length]);
        return sendPacket;
    }

    private static final String fixDecimalExponent(String dString) {
        char maybeMinusChar;
        int ePos = dString.indexOf("E");
        if (ePos == -1) {
            ePos = dString.indexOf("e");
        }
        if (ePos != -1 && dString.length() > ePos + 1 && (maybeMinusChar = dString.charAt(ePos + 1)) != '-') {
            StringBuffer buf = new StringBuffer(dString.length() + 1);
            buf.append(dString.substring(0, ePos + 1));
            buf.append('+');
            buf.append(dString.substring(ePos + 1, dString.length()));
            dString = buf.toString();
        }
        return dString;
    }

    private final void escapeblockFast(byte[] buf, ByteArrayOutputStream bytesOut, int size) {
        int lastwritten = 0;
        int i = 0;
        while (i < size) {
            byte b = buf[i];
            if (b == 0) {
                if (i > lastwritten) {
                    bytesOut.write(buf, lastwritten, i - lastwritten);
                }
                bytesOut.write(92);
                bytesOut.write(48);
                lastwritten = i + 1;
            } else if (b == 92 || b == 39 || b == 34) {
                if (i > lastwritten) {
                    bytesOut.write(buf, lastwritten, i - lastwritten);
                }
                bytesOut.write(92);
                lastwritten = i;
            }
            ++i;
        }
        if (lastwritten < size) {
            bytesOut.write(buf, lastwritten, size - lastwritten);
        }
    }

    private final void escapeblockFast(byte[] buf, Buffer packet, int size) throws SQLException {
        int lastwritten = 0;
        int i = 0;
        while (i < size) {
            byte b = buf[i];
            if (b == 0) {
                if (i > lastwritten) {
                    packet.writeBytesNoNull(buf, lastwritten, i - lastwritten);
                }
                packet.writeByte((byte)92);
                packet.writeByte((byte)48);
                lastwritten = i + 1;
            } else if (b == 92 || b == 39 || b == 34) {
                if (i > lastwritten) {
                    packet.writeBytesNoNull(buf, lastwritten, i - lastwritten);
                }
                packet.writeByte((byte)92);
                lastwritten = i;
            }
            ++i;
        }
        if (lastwritten < size) {
            packet.writeBytesNoNull(buf, lastwritten, size - lastwritten);
        }
    }

    private final int readblock(InputStream i, byte[] b, int length) throws SQLException {
        try {
            int lengthToRead = length;
            if (lengthToRead > b.length) {
                lengthToRead = b.length;
            }
            return i.read(b, 0, lengthToRead);
        }
        catch (Throwable E) {
            throw new SQLException("Error reading from InputStream " + E.getClass().getName(), "S1000");
        }
    }

    private final int readblock(InputStream i, byte[] b) throws SQLException {
        try {
            return i.read(b);
        }
        catch (Throwable E) {
            throw new SQLException("Error reading from InputStream " + E.getClass().getName(), "S1000");
        }
    }

    private final byte[] streamToBytes(InputStream in, int streamLength, boolean useLength) throws SQLException {
        return this.streamToBytes(in, true, streamLength, useLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] streamToBytes(InputStream in, boolean escape, int streamLength, boolean useLength) throws SQLException {
        byte[] byArray;
        try {
            if (streamLength == -1) {
                useLength = false;
            }
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            int bc = -1;
            bc = useLength ? this.readblock(in, this.streamConvertBuf, streamLength) : this.readblock(in, this.streamConvertBuf);
            int lengthLeftToRead = streamLength - bc;
            if (escape) {
                bytesOut.write(39);
            }
            while (bc > 0) {
                if (escape) {
                    this.escapeblockFast(this.streamConvertBuf, bytesOut, bc);
                } else {
                    bytesOut.write(this.streamConvertBuf, 0, bc);
                }
                if (useLength) {
                    bc = this.readblock(in, this.streamConvertBuf, lengthLeftToRead);
                    if (bc <= 0) continue;
                    lengthLeftToRead -= bc;
                    continue;
                }
                bc = this.readblock(in, this.streamConvertBuf);
            }
            if (escape) {
                bytesOut.write(39);
            }
            byArray = bytesOut.toByteArray();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                in.close();
            }
            catch (IOException ioEx) {
                // empty catch block
            }
            in = null;
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException ioEx) {
            // empty catch block
        }
        in = null;
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void streamToBytes(Buffer packet, InputStream in, boolean escape, int streamLength, boolean useLength) throws SQLException {
        block12: {
            try {
                if (streamLength == -1) {
                    useLength = false;
                }
                int bc = -1;
                bc = useLength ? this.readblock(in, this.streamConvertBuf, streamLength) : this.readblock(in, this.streamConvertBuf);
                int lengthLeftToRead = streamLength - bc;
                if (escape) {
                    packet.writeByte((byte)39);
                }
                while (bc > 0) {
                    if (escape) {
                        this.escapeblockFast(this.streamConvertBuf, packet, bc);
                    } else {
                        packet.writeBytesNoNull(this.streamConvertBuf, 0, bc);
                    }
                    if (useLength) {
                        bc = this.readblock(in, this.streamConvertBuf, lengthLeftToRead);
                        if (bc <= 0) continue;
                        lengthLeftToRead -= bc;
                        continue;
                    }
                    bc = this.readblock(in, this.streamConvertBuf);
                }
                if (escape) {
                    packet.writeByte((byte)39);
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    in.close();
                }
                catch (IOException ioEx) {
                    // empty catch block
                }
                in = null;
                throw throwable;
            }
            try {
                in.close();
                break block12;
            }
            catch (IOException ioEx) {
                // empty catch block
            }
            {
            }
        }
        in = null;
    }

    private static int readFully(Reader reader, char[] buf, int length) throws IOException {
        int numCharsRead = 0;
        while (numCharsRead < length) {
            int count = reader.read(buf, numCharsRead, length - numCharsRead);
            if (count < 0) break;
            numCharsRead += count;
        }
        return numCharsRead;
    }

    class EndPoint {
        int begin;
        int end;

        EndPoint(int b, int e) {
            this.begin = b;
            this.end = e;
        }
    }

    class BatchParams {
        boolean[] isNull = null;
        boolean[] isStream = null;
        InputStream[] parameterStreams = null;
        byte[][] parameterStrings = null;
        int[] streamLengths = null;

        BatchParams(byte[][] strings, InputStream[] streams, boolean[] isStreamFlags, int[] lengths, boolean[] isNullFlags) {
            this.parameterStrings = new byte[strings.length][];
            this.parameterStreams = new InputStream[streams.length];
            this.isStream = new boolean[isStreamFlags.length];
            this.streamLengths = new int[lengths.length];
            this.isNull = new boolean[isNullFlags.length];
            System.arraycopy(strings, 0, this.parameterStrings, 0, strings.length);
            System.arraycopy(streams, 0, this.parameterStreams, 0, streams.length);
            System.arraycopy(isStreamFlags, 0, this.isStream, 0, isStreamFlags.length);
            System.arraycopy(lengths, 0, this.streamLengths, 0, lengths.length);
            System.arraycopy(isNullFlags, 0, this.isNull, 0, isNullFlags.length);
        }
    }
}

