/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.AssertionFailedException;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.EscapeProcessor;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.RowDataStatic;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Statement
implements java.sql.Statement {
    protected List batchedArgs;
    protected Connection connection = null;
    protected int resultSetConcurrency = 0;
    protected int resultSetType = 0;
    protected String currentCatalog = null;
    protected boolean doEscapeProcessing = true;
    protected EscapeProcessor escaper = null;
    protected long lastInsertId = -1L;
    protected int maxFieldSize = MysqlIO.getMaxBuf();
    protected int maxRows = -1;
    protected boolean maxRowsChanged = false;
    protected ResultSet nextResults = null;
    protected ResultSet results = null;
    protected int timeout = 0;
    protected long updateCount = -1L;
    protected SQLWarning warningChain = null;
    private int fetchSize = 0;
    protected boolean isClosed = false;
    protected boolean pedantic = false;
    protected List openResults = new ArrayList();
    protected SingleByteCharsetConverter charConverter = null;
    protected String charEncoding = null;

    public Statement(Connection c, String catalog) throws SQLException {
        if (c == null || c.isClosed()) {
            throw new SQLException("Connection is closed.", "08003");
        }
        this.connection = c;
        this.escaper = new EscapeProcessor();
        this.currentCatalog = catalog;
        this.pedantic = this.connection.isPedantic();
        if (this.connection != null) {
            this.maxFieldSize = this.connection.getMaxAllowedPacket();
        }
        if (this.connection.useUnicode()) {
            this.charEncoding = this.connection.getEncoding();
            try {
                this.charConverter = SingleByteCharsetConverter.getInstance(this.charEncoding);
            }
            catch (UnsupportedEncodingException uEE) {
                throw new SQLException("Unsupported character encoding '" + this.charEncoding + "'", "S1009");
            }
        }
    }

    public java.sql.Connection getConnection() throws SQLException {
        return this.connection;
    }

    public void setCursorName(String name) throws SQLException {
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.doEscapeProcessing = enable;
    }

    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                throw new SQLException("Illegal value for setFetchDirection()", "S1009");
            }
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE || this.maxRows != 0 && this.maxRows != -1 && rows > this.getMaxRows()) {
            throw new SQLException("Illegal value for setFetchSize()", "S1009");
        }
        this.fetchSize = rows;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        Field[] fields = new Field[]{new Field("", "GENERATED_KEY", 4, 17)};
        ArrayList<byte[][]> rowSet = new ArrayList<byte[][]>();
        byte[][] row = new byte[][]{Long.toString(this.getLastInsertID()).getBytes()};
        rowSet.add(row);
        return new ResultSet(this.currentCatalog, fields, new RowDataStatic(rowSet), this.connection);
    }

    public long getLastInsertID() {
        return this.lastInsertId;
    }

    public long getLongUpdateCount() {
        if (this.results == null) {
            return -1L;
        }
        if (this.results.reallyResult()) {
            return -1L;
        }
        return this.updateCount;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        int maxBuf;
        if (max < 0) {
            throw new SQLException("Illegal value for setMaxFieldSize()", "S1009");
        }
        int n = maxBuf = this.connection != null ? this.connection.getMaxAllowedPacket() : MysqlIO.getMaxBuf();
        if (max > maxBuf) {
            throw new SQLException("Can not set max field size > max allowed packet: " + maxBuf, "S1009");
        }
        this.maxFieldSize = max;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public void setMaxRows(int max) throws SQLException {
        if (max > 50000000 || max < 0) {
            throw new SQLException("setMaxRows() out of range. " + max + " > " + 50000000 + ".", "S1009");
        }
        if (max == 0) {
            max = -1;
        }
        this.maxRows = max;
        this.maxRowsChanged = true;
        if (this.maxRows == -1) {
            this.connection.unsetMaxRows(this);
            this.maxRowsChanged = false;
        } else {
            this.connection.maxRowsChanged(this);
        }
    }

    public int getMaxRows() throws SQLException {
        if (this.maxRows <= 0) {
            return 0;
        }
        return this.maxRows;
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    public synchronized boolean getMoreResults(int current) throws SQLException {
        switch (current) {
            case 1: {
                if (this.results == null) break;
                this.results.close();
                break;
            }
            case 3: {
                if (this.results != null) {
                    this.results.close();
                }
                this.closeAllOpenResults();
                break;
            }
            case 2: {
                this.openResults.add(this.results);
                break;
            }
            default: {
                throw new SQLException("Illegal flag for getMoreResults(int)", "S1009");
            }
        }
        this.results = this.nextResults;
        this.nextResults = null;
        return this.results != null && this.results.reallyResult();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new SQLException("Illegal value for setQueryTimeout()", "S1009");
        }
        this.timeout = seconds;
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    public synchronized java.sql.ResultSet getResultSet() throws SQLException {
        return this.results != null && this.results.reallyResult() ? this.results : null;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    public synchronized int getUpdateCount() throws SQLException {
        if (this.results == null) {
            return -1;
        }
        if (this.results.reallyResult()) {
            return -1;
        }
        int truncatedUpdateCount = 0;
        truncatedUpdateCount = this.results.getUpdateCount() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.results.getUpdateCount();
        return truncatedUpdateCount;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    public synchronized void addBatch(String sql) throws SQLException {
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList();
        }
        if (sql != null) {
            this.batchedArgs.add(sql);
        }
    }

    public void cancel() throws SQLException {
    }

    public synchronized void clearBatch() throws SQLException {
        if (this.batchedArgs != null) {
            this.batchedArgs.clear();
        }
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    public synchronized void close() throws SQLException {
        if (this.results != null) {
            try {
                this.results.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.maxRowsChanged) {
            this.connection.unsetMaxRows(this);
        }
        this.results = null;
        this.connection = null;
        this.warningChain = null;
        this.escaper = null;
        this.isClosed = true;
        this.closeAllOpenResults();
        this.openResults = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean execute(String sql) throws SQLException {
        if (this.connection.isReadOnly() && sql != null) {
            int length = sql.length();
            int firstNonWsChar = 0;
            int i = 0;
            while (i < length) {
                char c = sql.charAt(i);
                if (!Character.isWhitespace(c)) {
                    firstNonWsChar = c;
                    break;
                }
                ++i;
            }
            if (firstNonWsChar != 83 && firstNonWsChar != 115) {
                throw new SQLException("Connection is read-only. Queries leading to data modification are not allowed", "S1009");
            }
        }
        this.checkClosed();
        if (this.doEscapeProcessing) {
            sql = this.escaper.escapeSQL(sql);
        }
        if (this.results != null) {
            this.results.close();
        }
        ResultSet rs = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            char firstChar;
            boolean isSelect;
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            boolean bl = isSelect = (firstChar = Character.toUpperCase(sql.charAt(0))) == 'S';
            if (this.connection.useMaxRows()) {
                if (isSelect) {
                    if (sql.toUpperCase().indexOf("LIMIT") != -1) {
                        rs = this.connection.execSQL(sql, this.maxRows, this.resultSetConcurrency, this.createStreamingResultSet(), true, this.currentCatalog);
                    } else if (this.maxRows <= 0) {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, this.currentCatalog);
                    } else {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this.maxRows, -1, this.currentCatalog);
                    }
                } else {
                    this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, this.currentCatalog);
                }
                rs = this.connection.execSQL(sql, -1, this.resultSetConcurrency, this.createStreamingResultSet(), isSelect, this.currentCatalog);
            } else {
                rs = this.connection.execSQL(sql, -1, this.resultSetConcurrency, this.createStreamingResultSet(), isSelect, this.currentCatalog);
            }
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        this.lastInsertId = rs.getUpdateID();
        if (rs != null) {
            this.results = rs;
        }
        rs.setConnection(this.connection);
        rs.setResultSetType(this.resultSetType);
        rs.setResultSetConcurrency(this.resultSetConcurrency);
        return rs != null && rs.reallyResult();
    }

    public boolean execute(String arg0, int arg1) throws SQLException {
        return this.execute(arg0);
    }

    public boolean execute(String arg0, int[] arg1) throws SQLException {
        return this.execute(arg0);
    }

    public boolean execute(String arg0, String[] arg1) throws SQLException {
        return this.execute(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int[] executeBatch() throws SQLException {
        int[] nArray;
        if (this.connection.isReadOnly()) {
            throw new SQLException("Connection is read-only. Queries leading to data modification are not allowed", "S1009");
        }
        try {
            int[] updateCounts = null;
            if (this.batchedArgs != null) {
                int nbrCommands = this.batchedArgs.size();
                updateCounts = new int[nbrCommands];
                int i = 0;
                while (i < nbrCommands) {
                    updateCounts[i] = -3;
                    ++i;
                }
                Throwable sqlEx = null;
                int commandIndex = 0;
                commandIndex = 0;
                while (commandIndex < nbrCommands) {
                    try {
                        updateCounts[commandIndex] = this.executeUpdate((String)this.batchedArgs.get(commandIndex));
                    }
                    catch (SQLException ex) {
                        updateCounts[commandIndex] = -3;
                        if (this.connection.continueBatchOnError()) {
                            sqlEx = ex;
                        }
                        int[] newUpdateCounts = new int[commandIndex];
                        System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                        throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                    }
                    ++commandIndex;
                }
                if (sqlEx != null) {
                    throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
                }
            }
            nArray = updateCounts != null ? updateCounts : new int[]{};
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.clearBatch();
            throw throwable;
        }
        this.clearBatch();
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized java.sql.ResultSet executeQuery(String sql) throws SQLException {
        char firstStatementChar;
        this.checkClosed();
        if (this.doEscapeProcessing) {
            sql = this.escaper.escapeSQL(sql);
        }
        if (((firstStatementChar = StringUtils.firstNonWsCharUc(sql)) == 'I' || firstStatementChar == 'U' || firstStatementChar == 'D' || firstStatementChar == 'A' || firstStatementChar == 'C') && (StringUtils.startsWithIgnoreCaseAndWs(sql, "INSERT") || StringUtils.startsWithIgnoreCaseAndWs(sql, "UPDATE") || StringUtils.startsWithIgnoreCaseAndWs(sql, "DELETE") || StringUtils.startsWithIgnoreCaseAndWs(sql, "DROP") || StringUtils.startsWithIgnoreCaseAndWs(sql, "CREATE") || StringUtils.startsWithIgnoreCaseAndWs(sql, "ALTER"))) {
            throw new SQLException("Can not issue data manipulation statements with executeQuery()", "S1009");
        }
        if (this.results != null) {
            this.results.close();
        }
        Object object = this.connection.getMutex();
        synchronized (object) {
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.useMaxRows()) {
                if (sql.toUpperCase().indexOf("LIMIT") != -1) {
                    this.results = this.connection.execSQL(sql, this.maxRows, this.resultSetConcurrency, this.createStreamingResultSet(), true, this.currentCatalog);
                } else {
                    if (this.maxRows <= 0) {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, this.currentCatalog);
                    } else {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this.maxRows, -1, this.currentCatalog);
                    }
                    this.results = this.connection.execSQL(sql, -1, this.resultSetConcurrency, this.createStreamingResultSet(), true, this.currentCatalog);
                    if (oldCatalog != null) {
                        this.connection.setCatalog(oldCatalog);
                    }
                }
            } else {
                this.results = this.connection.execSQL(sql, -1, this.resultSetConcurrency, this.createStreamingResultSet(), true, this.currentCatalog);
            }
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        this.lastInsertId = this.results.getUpdateID();
        this.nextResults = this.results;
        this.results.setConnection(this.connection);
        this.results.setResultSetType(this.resultSetType);
        this.results.setResultSetConcurrency(this.resultSetConcurrency);
        this.results.setStatement(this);
        if (!this.results.reallyResult()) {
            if (!this.connection.getAutoCommit()) {
                this.connection.rollback();
            }
            throw new SQLException("Can not issue INSERT/UPDATE/DELETE with executeQuery()", "S1009");
        }
        return this.results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int executeUpdate(String sql) throws SQLException {
        if (this.connection.isReadOnly()) {
            throw new SQLException("Connection is read-only. Queries leading to data modification are not allowed", "S1009");
        }
        if (StringUtils.startsWithIgnoreCaseAndWs(sql, "select")) {
            throw new SQLException("Can not issue SELECT via executeUpdate()", "S1009");
        }
        this.checkClosed();
        if (this.doEscapeProcessing) {
            sql = this.escaper.escapeSQL(sql);
        }
        ResultSet rs = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.useMaxRows()) {
                this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, this.currentCatalog);
            }
            rs = this.connection.execSQL(sql, -1, 1007, false, false, this.currentCatalog);
            rs.setConnection(this.connection);
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        this.updateCount = rs.getUpdateCount();
        int truncatedUpdateCount = 0;
        truncatedUpdateCount = this.updateCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.updateCount;
        this.lastInsertId = rs.getUpdateID();
        return truncatedUpdateCount;
    }

    public int executeUpdate(String arg0, int arg1) throws SQLException {
        return this.executeUpdate(arg0);
    }

    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        return this.executeUpdate(arg0);
    }

    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        return this.executeUpdate(arg0);
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("No operations allowed after statement closed", "08003");
        }
    }

    void setResultSetConcurrency(int concurrencyFlag) {
        this.resultSetConcurrency = concurrencyFlag;
    }

    void setResultSetType(int typeFlag) {
        this.resultSetType = typeFlag;
    }

    protected boolean createStreamingResultSet() {
        return this.resultSetType == 1003 && this.resultSetConcurrency == 1007 && this.fetchSize == Integer.MIN_VALUE;
    }

    protected void closeAllOpenResults() {
        if (this.openResults != null) {
            Iterator iter = this.openResults.iterator();
            while (iter.hasNext()) {
                ResultSet element = (ResultSet)iter.next();
                try {
                    element.close();
                }
                catch (SQLException sqlEx) {
                    AssertionFailedException.shouldNotHappen(sqlEx);
                }
            }
            this.openResults.clear();
        }
    }
}

