/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.jdbc2.optional;

import com.mysql.jdbc.jdbc2.optional.LogicalHandle;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class MysqlPooledConnection
implements PooledConnection {
    private Hashtable eventListeners;
    private Connection logicalHandle = null;
    private Connection physicalConn;

    public MysqlPooledConnection(Connection connection) {
        this.physicalConn = connection;
        this.eventListeners = new Hashtable(10);
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectioneventlistener) {
        if (this.eventListeners != null) {
            this.eventListeners.put(connectioneventlistener, connectioneventlistener);
        }
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectioneventlistener) {
        if (this.eventListeners != null) {
            this.eventListeners.remove(connectioneventlistener);
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.physicalConn == null) {
            SQLException sqlException = new SQLException("Physical Connection doesn't exist");
            this.callListener(2, sqlException);
            return null;
        }
        try {
            if (this.logicalHandle != null) {
                this.logicalHandle.close();
            }
            this.logicalHandle = new LogicalHandle(this, this.physicalConn);
        }
        catch (SQLException sqlException) {
            this.callListener(2, sqlException);
            return null;
        }
        return this.logicalHandle;
    }

    public synchronized void close() throws SQLException {
        this.physicalConn.close();
        this.physicalConn = null;
        this.callListener(2, null);
    }

    protected synchronized void callListener(int i, SQLException sqlException) {
        if (this.eventListeners == null) {
            return;
        }
        Enumeration enumeration = this.eventListeners.keys();
        ConnectionEvent connectionevent = new ConnectionEvent(this, sqlException);
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectioneventlistener = (ConnectionEventListener)enumeration.nextElement();
            ConnectionEventListener connectioneventlistener1 = (ConnectionEventListener)this.eventListeners.get(connectioneventlistener);
            if (i == 1) {
                connectioneventlistener1.connectionClosed(connectionevent);
                continue;
            }
            if (i != 2) continue;
            connectioneventlistener1.connectionErrorOccurred(connectionevent);
        }
    }
}

