/* pnp.c
 *
 * This source code is taken from John Watton's paper
 *
 *	"Comparing C, Fortran, Listp, Java, Python, Perl, Scheme (Guile),
 *	and TCL using a floating point numerical test --- point inside
 *	polygon".
 *
 * and slightly modified.  This version uses an array of points, instead of two arrays of doubles,
 * to represent the polygon.  It is about 2% slower than the original version, but a more natural
 * implementation.
 * 
 * The original source is attributed to W.R. Franklin.
 */

#include <stdio.h>

#define NUM_ITERS	1000000

typedef int Bool_t;
#define TRUE	1
#define FALSE	0

typedef struct { double x, y; } Pt_t;

Bool_t pnpoly (int npol, Pt_t *p, double x, double y)
{
    int	i, j;
    Bool_t c = FALSE;
    for (i = 0, j = npol-1;  i < npol;  j = i++) {
	if ((((p[i].y <= y) && (y < p[j].y)) || ((p[j].y <= y) && (y < p[i].y)))
	&& (x < ((p[j].x - p[i].x) * (y - p[i].y)) /( p[j].y - p[i].y) + p[i].x))
	    c = !c;
    }
    return c;
}

main ()
{
    int		npol = 20;
    Pt_t	p[20] = {
	    {0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0,}, {0.0, 1.0}, {0.0, 2.0},
	    {1.0, 3.0}, {-0.5, 2.0}, {-1.0, 3.0}, {-1.0, 0.0}, {-2.0, -0.5},
	    {-2.5, -1.0}, {-2.0, -1.5}, {-1.5, -2.0}, {-0.5, -2.0}, {1.0, -1.5},
	    {1.0, -1.0}, {0.0, -0.5}, {-0.5, -1.0}, {-1.0, -1.0}, {-0.5, -0.5}
	};

    int	i, count;
    for (count = 0, i = 0;  i < NUM_ITERS;  i++) {
	if (pnpoly(npol, p, 0.5, 0.5)) count++;
	if (pnpoly(npol, p, 0.5, 1.5)) count++;
	if (pnpoly(npol, p, -0.5, 1.5)) count++;
	if (pnpoly(npol, p, 0.75, 2.25)) count++;
	if (pnpoly(npol, p, 0.0, 2.01)) count++;
	if (pnpoly(npol, p, -0.5, 2.5)) count++;
	if (pnpoly(npol, p, -1.0, -0.5)) count++;
	if (pnpoly(npol, p, -1.5, 0.5)) count++;
	if (pnpoly(npol, p, -2.25, -1.0)) count++;
	if (pnpoly(npol, p, 0.5, -0.25)) count++;
	if (pnpoly(npol, p, 0.5, -1.25)) count++;
	if (pnpoly(npol, p, -0.5, -2.5)) count++;
    }

    printf ("count %d\n", count);
    return 0;

}
