/* pt-in-poly.c
 *
 * This source code is taken from John Watton's paper
 *
 *	"Comparing C, Fortran, Listp, Java, Python, Perl, Scheme (Guile),
 *	and TCL using a floating point numerical test --- point inside
 *	polygon".
 *
 * and slightly modified.  The original source is attributed to W.R. Franklin.
 */

#include <stdio.h>

#define NUM_ITERS	1000000

typedef int Bool_t;
#define TRUE	1
#define FALSE	0

Bool_t pnpoly (int npol, double *xp, double *yp, double x, double y)
{
    int	i, j;
    Bool_t c = FALSE;
    for (i = 0, j = npol-1;  i < npol;  j = i++) {
	if ((((yp[i] <= y) && (y < yp[j])) || ((yp[j] <= y) && (y < yp[i])))
	&& (x < ((xp[j] - xp[i]) * (y - yp[i])) /( yp[j] - yp[i]) + xp[i]))
	    c = !c;
    }
    return c;
}

main ()
{
    int		npol = 20;
    double xp[20] = {
	    0.0, 1.0, 1.0, 0.0, 0.0, 1.0, -0.5, -1.0, -1.0, -2.0,
	    -2.5, -2.0, -1.5, -0.5, 1.0, 1.0, 0.0, -0.5, -1.0, -0.5
	};
    double yp[20] = {
	    0.0, 0.0, 1.0, 1.0, 2.0, 3.0, 2.0, 3.0, 0.0, -0.5,
	    -1.0, -1.5, -2.0, -2.0, -1.5, -1.0, -0.5, -1.0, -1.0, -0.5
	};

    int	i, count;
    for (count = 0, i = 0;  i < NUM_ITERS;  i++) {
	if (pnpoly(npol, xp, yp, 0.5, 0.5)) count++;
	if (pnpoly(npol, xp, yp, 0.5, 1.5)) count++;
	if (pnpoly(npol, xp, yp, -0.5, 1.5)) count++;
	if (pnpoly(npol, xp, yp, 0.75, 2.25)) count++;
	if (pnpoly(npol, xp, yp, 0.0, 2.01)) count++;
	if (pnpoly(npol, xp, yp, -0.5, 2.5)) count++;
	if (pnpoly(npol, xp, yp, -1.0, -0.5)) count++;
	if (pnpoly(npol, xp, yp, -1.5, 0.5)) count++;
	if (pnpoly(npol, xp, yp, -2.25, -1.0)) count++;
	if (pnpoly(npol, xp, yp, 0.5, -0.25)) count++;
	if (pnpoly(npol, xp, yp, 0.5, -1.25)) count++;
	if (pnpoly(npol, xp, yp, -0.5, -2.5)) count++;
    }

    printf ("count %d\n", count);
    return 0;

}
