/* mand.c
 *
 * A version of mandelbrot that produces an ASCII image.
 * The original code was by Glenn Rhoads.
 */

#include <stdio.h>

main ()
{
   int x, y, k;
   char *b = " .:,;!/>)|&IH%*#";
   double r, i, z, Z, t, c, C;

   for (y=30;  y > 0;  y--) {
	C = y*0.1 - 1.5;
	for (x = 0;  x < 75;  x++) {
	    c = x*0.04 - 2;
	    z = 0.0; Z = 0.0;
	    for (r=c, i=C, k = 0;  k < 112;  k++) {
		t = z*z - Z*Z + r;
		Z = 2*z*Z + i;
		z = t;
		if (z*z + Z*Z > 10.0) break;
	    }
	    printf ("%c", b[k%16]);
	}
	printf ("\n");
    }
}

