(* mand.sml
 *
 * A version of mandelbrot that produces an ASCII image.
 *)

structure Main : sig

    val doit : unit -> unit
    val main : (string * string list) -> OS.Process.status

  end = struct

    val b = " .:,;!/>)|&IH%*#"

    fun say c = TextIO.output1(TextIO.stdOut, c)

    fun lp_y y = if (y > 0)
	  then let
	    val im = (real y)*0.1 - 1.5;
	    fun lp_x x = if (x < 75)
		  then let
		    val re = (real x)*0.04 - 2.0
		    fun lp_k (k, z, Z) = if (k < 112)
			  then let
			    val t = z*z - Z*Z + re
			    val Z = 2.0*z*Z + im
			    val z = t
			    in
			      if (z*z + Z*Z > 10.0)
				then k
				else lp_k (k+1, z, Z)
			    end
			  else k
		    in
		      say (String.sub(b, (lp_k(0, 0.0, 0.0)) mod 16));
		      lp_x (x+1)
		    end
		  else ()
	    in
	      lp_x (0);
	      say #"\n";
	      lp_y (y-1)
	    end
	  else ()

    fun doit () = lp_y 30

    fun main _ = (doit(); OS.Process.success)

  end
