#ifndef _QUEUE_H_
#define _QUEUE_H_

struct ListNode {
	int data;
	ListNode *next;
};

struct Queue {
	ListNode *head;
	ListNode *tail;
};

// Creates a new queue
void createQueue(Queue &q);

// Enqueues a new element
void enqueue(Queue &q, int data);

// Dequeues a new element
// Assumes queue is non-empty
int dequeue(Queue &q);

// Returns the value of the first element in the queue,
// without dequeuing
int peek(Queue &q);

// Returns true if the queue is empty
bool isEmpty(Queue &q);

// Prints out the contents of the queue
void printQueue(Queue &q);

// Destroys queue
void destroyQueue(Queue &q);

#endif //_QUEUE_H_
