#include "stack.h"
#include <cstdlib>
#include <iostream>
using namespace std;

void createStack(Stack &s)
{
	s.head = NULL;
}

bool isEmpty(Stack &s)
{
	return (s.head==NULL);
}

int peek(Stack &s)
{
	return s.head->data;
}

int pop(Stack &s)
{
	int data = s.head->data;
	deleteHead(s);
	
	return data;
}

void push(Stack &s, int data)
{
	StackNode *new_node = new StackNode;
	new_node->data = data;
	new_node->next = s.head;
	s.head = new_node;
}

void push_str(Stack &s, string num)
{
	push(s, atoi(num.c_str()));
}

void printStack(Stack &s)
{
	StackNode *cur;
	cur = s.head;
	if(cur == NULL)
		cout << "Stack is empty!";
	else
		while (cur != NULL)
		{
			cout << cur->data << " ";
			cur = cur->next;
		}
	cout << endl;
}

void deleteHead(Stack &s)
{
	if (s.head != NULL)
	{
		StackNode *new_head = s.head->next;
		delete s.head;
		s.head = new_head;
	}
}


