#include"DynamicArray.h"
#include<iostream>
#include<iomanip>
using namespace std;

int main(int argc, char** argv)
{
	int a[5] = {42,42,42,42,42}, code;
	DynamicArray a1, a2(a,5), a3 = a2, *a4;
	
	a4 = new DynamicArray(a2);

	cout << "FIRST ASSIGNMENT" << endl;
	code = a1.setValue(0,37);
	if(code == DynamicArray::SET_OK_NOGROW)
		cout << "Did not have to grow the array." << endl << endl;
	else if (code == DynamicArray::SET_OK_GROW)
		cout << "Had to grow the array." << endl << endl;
	
	cout << "SECOND ASSIGNMENT" << endl;
	code = a1.setValue(4,23);
	if(code == DynamicArray::SET_OK_NOGROW)
		cout << "Did not have to grow the array." << endl << endl;
	else if (code == DynamicArray::SET_OK_GROW)
		cout << "Had to grow the array." << endl << endl;

	cout << "THIRD ASSIGNMENT" << endl;
	code = a1.setValue(2,7);
	if(code == DynamicArray::SET_OK_NOGROW)
		cout << "Did not have to grow the array." << endl << endl;
	else if (code == DynamicArray::SET_OK_GROW)
		cout << "Had to grow the array." << endl << endl;

	cout << "ARRAY A1: " <<  a1 << endl;
	cout << "ARRAY A2: " <<  a2 << endl;
	cout << "ARRAY A3: " <<  a3 << endl;
	cout << "ARRAY A4: " <<  *a4 << endl;

	cout << endl;
	
	cout << "ACCESSING VALUES" << endl;
	int value;
	code = a1.getValue(2,value);  
	if(code == DynamicArray::GET_OK)
		cout << "Position 2: " << value << endl;
	else if (code == DynamicArray::GET_ERROR_BADPOS)
		cout << "Position out of range." << endl;
	code = a1.getValue(9,value);
	if(code == DynamicArray::GET_OK)
		cout << "Position 9:" << value << endl << endl;
	else if (code == DynamicArray::GET_ERROR_BADPOS)
		cout << "Position out of range." << endl << endl;
	
	cout << "COMPARISONS" << endl;
	if(a1 == a2)
			cout << "a1 and a2 have the same contents." << endl;
	else
			cout << "a1 and a2 don't have the same contents." << endl;
	if(a1 == a3)
			cout << "a1 and a3 have the same contents." << endl;
	else
			cout << "a1 and a3 don't have the same contents." << endl;
	if(a2 == a3)
			cout << "a2 and a3 have the same contents." << endl;
	else
			cout << "a2 and a3 don't have the same contents." << endl;
	cout << endl;
	
	cout << "ASSIGNMENT" << endl;
	*a4 = a1;
	cout << "ARRAY A1: " <<  a1 << endl;
	cout << "ARRAY A2: " <<  a2 << endl;
	cout << "ARRAY A3: " <<  a3 << endl;
	cout << "ARRAY A4: " <<  *a4 << endl;

	cout << endl;
	
	cout << "BRACKET OPERATOR" << endl;	
	
	cout << "a1[2] = " << a1[2] << endl;
	cout << "a1[4] = " << a1[4] << endl;
		
	a1[10] = 100;
	
	cout << "a1[10] = " << a1[10] << endl;
	cout << "ARRAY A1: " <<  a1 << endl;

	return 0;	
}
