#include <iostream>
#include <fstream>
using namespace std;

/* We declare the structure we want to write to the binary
 * file. Notice how it has no pointers or objects (like "string").
 * Writing a struct with pointers and objects to a binary file
 * is tricky: a common mistake is to write the 4-byte address to
 * the file, instead of the actual contents being pointed at by
 * the pointer.
 *
 * In this case we will only consider structs without pointers.
 */
struct Empl {
    char name[100];
    int age;
    float salary;
};

int main()
{
    /* We open the file in binary mode */
    ofstream file("empl.dat", ios::binary);
    
    /* Check the that file has been opened correctly */
    if (file.fail())
    {
	cout << "Error opening file for writing." << endl;
	exit(1);
    }

    /* We create two Empl structs */
    Empl e1;
    Empl e2;

    strcpy(e1.name, "Borja");
    strcpy(e2.name, "John");
    e1.age=24;
    e2.age=40;
    e1.salary=100.0;
    e2.salary=200.0;

    /* We write them to the binary file using the "write" method.
     * The write method is declared like this:
     * 
     *     write(char *s, int len)
     *
     * It might seem that it simply allows us to write strings
     * to a file but, in fact, it can also be used to copy
     * whole chunks of memory into a file. In our case, we want
     * to copy the Empl structs into the file. To do this,
     * our first parameter will be the address of the struct,
     * which we cast into char*. This way, "write" will deal
     * with it as if it were an array of bytes (the char datatype
     * takes up on byte of memory). The second parameter will
     * be the size of the structs (the number of bytes it
     * occupies in memory). We can use the sizeof() operator
     * to obtain this size.
     */
    file.write((char *) &e1, sizeof(e1));
    file.write((char *) &e2, sizeof(e2));

    /* Close the file */
    file.close();
}
