#include <iostream>
#include <fstream>
using namespace std;

/* We declare the Empl struct. */
/* See comment in writeEmplFileBin.cpp */
struct Empl {
    char name[100];
    int age;
    float salary;
};

int main()
{
    /* Open an input stream in binary mode */
    ifstream file("empl.dat", ios::binary);
    
    /* Check for problems when opening the file */
    if (file.fail())
    {
	cout << "Error opening file for reading." << endl;
	exit(1);
    }

    /* Declare two Empl structs which we'll read from the binary
     * file */
    Empl e1, e2;

    /* We read from the the binary file using the "read" method.
     * The read method is declared like this:
     *
     *     read(char *s, int len)
     *
     * It might seem that it simply allows us to read strings
     * from a file but, in fact, it can also be used to copy
     * whole chunks of binary data from the file into memory.
     * In our case, we want to copy the Empl structs from the
     * file created in writeEmplFileBin.cpp into memory. To do this,
     * our first parameter will be the address of the struct,
     * which we cast into char*. This way, "read" will deal
     * with it as if it were an array of bytes (the char datatype
     * takes up on byte of memory). The second parameter will
     * be the size of the structs (the number of bytes it
     * occupies in memory). We can use the sizeof() operator
     * to obtain this size.
     */
    file.read((char *) &e1, sizeof(e1));
    file.read((char *) &e2, sizeof(e2));

    /* Write structs to screen */
    cout << e1.name << endl;
    cout << e1.age << endl;
    cout << e1.salary << endl;
    cout << e2.name << endl;
    cout << e2.age << endl;
    cout << e2.salary << endl;

    /* Close file */
    file.close();
}
