#include "list.h"
#include <cstdlib>
#include <iostream>
using namespace std;

void createList(List &l)
{
	l.head = NULL;
	l.tail = NULL;
}

ListNode* first(List &l)
{
	return l.head;
}

ListNode* last(List &l)
{
	return l.tail;
}

void insertHead(List &l, int data)
{
	ListNode *new_node = new ListNode;
	new_node->data = data;
	new_node->next = l.head;
	l.head = new_node;
	
	if (l.tail == NULL)
		l.tail = new_node;
}

void insertTail(List &l, int data)
{
	insertAfter(l, l.tail, data);	
}

void insertAfter(List &l, ListNode* node, int data)
{
	ListNode *new_node = new ListNode;
	new_node->data = data;
	new_node->next = node->next;
	node->next = new_node;
	
	if (new_node->next == NULL)
		l.tail = new_node;
}

void printData(List &l)
{
	ListNode *cur;
	cur = l.head;
	if(cur == NULL)
		cout << "List is empty!";
	else
		while (cur != NULL)
		{
			cout << cur->data << " ";
			cur = cur->next;
		}
	cout << endl;
}

bool find(List &l, int data)
{
	ListNode *cur;
	bool found = false;
	
	cur = l.head;
	
	while(!found && cur!=NULL)
		if(cur->data==data)
			found = true;
		else
			cur = cur->next;
			
	return found;
}

void deleteHead(List &l)
{
	if (l.head != NULL)
	{
		ListNode *new_head = l.head->next;
		delete l.head;
		l.head = new_head;
		if (new_head == NULL)
			l.tail = NULL;
	}
}

void deleteAfter(List &l, ListNode* node)
{
	if(node->next != NULL)
	{
		ListNode *new_next = node->next->next;
		delete node->next;
		node->next = new_next;
		
		if(new_next == NULL)
			l.tail = node;
	}
}

void deleteData(List &l, int data)
{
	ListNode *cur, *prev;
	
	cur = l.head;
	prev = NULL;
	
	while(cur != NULL)
	{
		if(cur->data == data)
		{
			if (prev!=NULL)
			{
				cur = cur->next;
				deleteAfter(l, prev);
			}
			else
			{
				deleteHead(l);
				cur = l.head;
			}
		}
		else
		{
			prev = cur;
			cur = cur->next;
		}
	}
}

void deleteList(List &l)
{
	while(l.head != NULL)
		deleteHead(l);		
}
