#include "stack.h"
#include <cstdlib>
#include <iostream>
using namespace std;

/* LIST NODE CONSTRUCTOR */
ListNode::ListNode(int data, ListNode *next)
{
	this->data = data;
	this->next = next;
}


/* LIST NODE PUBLIC MEMBER FUNCTIONS */
int ListNode::getData()
{
	return data;
}

void ListNode::setData(int data)
{
	this->data = data;
}

ListNode* ListNode::getNext()
{
	return next;
}

void ListNode::setNext(ListNode *next)
{
	this->next = next;
}


/* STACK PRIVATE MEMBER FUNCTIONS */
void Stack::insertHead(int data)
{
	ListNode *new_node = new ListNode(data, head);
	head = new_node;
}

void Stack::deleteHead()
{
	if (head != NULL)
	{
		ListNode *new_head = head->getNext();
		delete head;
		head = new_head;
	}
}


/* STACK CONSTRUCTORS */
Stack::Stack()
{
	head = NULL;
}

Stack::Stack(int a[], int length)
{
	head = NULL;
	for(int i=0; i<length; i++)
		push(a[i]);
}


/* STACK DESTRUCTOR */
Stack::~Stack()
{
	while(head != NULL)
		deleteHead();		
}


/* STACK PUBLIC MEMBER FUNCTIONS */
int Stack::pop()
{
	int value = peek();
	deleteHead();
	return value;
}

void Stack::push(int data)
{
	insertHead(data);
}

int Stack::peek()
{
	return head->getData();
}

bool Stack::isEmpty()
{
	return (head==NULL);	
}

void Stack::printContents(ostream &os)
{
	ListNode *cur;
	cur = head;
	if(cur == NULL)
		os << "Stack is empty!";
	else
		while (cur != NULL)
		{
			os << cur->getData() << " ";
			cur = cur->getNext();
		}
	os << endl;
}


/* STACK OPERATOR OVERLOAD */
void Stack::operator<<(int data)
{
	push(data);
}

void Stack::operator>>(int &data)
{
	data = pop();
}

