#ifndef _STACK_H_
#define _STACK_H_

#include <iostream>
using namespace std;

class ListNode {
	private:
		int data;
		ListNode *next;
		
	public:
		ListNode(int data, ListNode *next);
		int getData();
		void setData(int data);
		ListNode* getNext();
		void setNext(ListNode *next);
};

class Stack {
	private:
		ListNode *head;
		
		// Private member functions
		void insertHead(int data);
		void deleteHead();
		
	public:
		// Constructors
		Stack();
		Stack(int a[], int length);
		~Stack();
		
		// Member functions
		int pop();
		void push(int data);
		int peek();
		bool isEmpty();
		void printContents(ostream &os);
		
		// Operator overload
		void operator<<(int data);
		void operator>>(int &data);
};

#endif //_STACK_H_
