#include "tree.h"
#include <iostream>
using namespace std;

void insertWithCheck(Tree &t, int value)
{
	if (! insert(t, value) )
		cout << "Could not insert value " << value << ". Already in tree." << endl;	
}

int main()
{
	Tree t1;
	
	cout << "CREATING AND INSERTING" << endl;
	cout << "----------------------" << endl;
	createTree(t1);
	insertWithCheck(t1, 15);
	insertWithCheck(t1, 10);
	insertWithCheck(t1, 23);
	insertWithCheck(t1, 4);
	insertWithCheck(t1, 13);
	insertWithCheck(t1, 15);
	insertWithCheck(t1, 17);
	insertWithCheck(t1, 17);
	insertWithCheck(t1, 29);
	insertWithCheck(t1, 12);
	insertWithCheck(t1, 25);
	insertWithCheck(t1, 23);

	cout << "The height of the tree is " << height(t1) << endl;

	cout << endl;
	cout << "TRAVERSALS" << endl;
	cout << "----------" << endl;
	inorder(t1);
	cout << endl;

	preorder(t1);
	cout << endl;

	postorder(t1);
	cout << endl;
	 
	cout << endl;
	cout << "BINARY SEARCH" << endl;
	cout << "-------------" << endl;
	if (find(t1, 10))
		cout << "Value 10 is contained in the tree." << endl;
	else
		cout << "Value 10 is NOT contained in the tree." << endl;

	if (find(t1, 29))
		cout << "Value 29 is contained in the tree." << endl;
	else
		cout << "Value 29 is NOT contained in the tree." << endl;

	if (find(t1, 48))
		cout << "Value 48 is contained in the tree." << endl;
	else
		cout << "Value 48 is NOT contained in the tree." << endl;

	cout << endl;
	cout << "REMOVAL OF NODES" << endl;
	cout << "----------------" << endl;
	inorder(t1);
	cout << endl;
	cout << "Removing node 25:" << endl;
	remove(t1, 25);
	inorder(t1);
	cout << endl;
	cout << "The height of the tree is " << height(t1) << endl;
	cout << "Removing node 13:" << endl;
	remove(t1, 13);
	inorder(t1);
	cout << endl;
	cout << "The height of the tree is " << height(t1) << endl;
	cout << "Removing node 15:" << endl;
	remove(t1, 15);
	inorder(t1);
	cout << endl;
	cout << "The height of the tree is " << height(t1) << endl;
}
