#include "tree.h"
#include "queue.h"
#include <cstdlib>
#include <iostream>
using namespace std;


void createTree(Tree &t)
{
	t = NULL;
}

bool insert(Tree &t, int value)
{
	TreeNode *tn = new TreeNode;
	
	tn->left = NULL;
	tn->value = value;
	tn->right = NULL;
		
	TreeNode *cur = t, *prev=NULL;
	bool found = false;
	
	while(cur != NULL && !found)
	{
		if(cur->value == value)
			found = true;
		else if (value < cur->value)
		{
			prev = cur;
			cur = cur->left;
		}
		else
		{
			prev = cur;
			cur = cur->right;
		}
	}
	
	if(!found)
	{
		if(prev == NULL)
			t = tn;
		else
		{
			if (value < prev->value)
				prev->left = tn;
			else
				prev->right = tn;
		}
	}
	
	return !found;
}

void inorder(Tree &t)
{
	if(t!=NULL)
	{
		inorder(t->left);
		cout << t->value << " ";
		inorder(t->right);
	}	
}

void preorder(Tree &t)
{
	if(t!=NULL)
	{
		cout << t->value << " ";
		preorder(t->left);
		preorder(t->right);
	}	
}

void postorder(Tree &t)
{
	if(t!=NULL)
	{
		postorder(t->left);
		postorder(t->right);
		cout << t->value << " ";
	}	
}

bool find(Tree &t, int value)
{
	if (t == NULL)
		return false;
	else if(t->value == value)	
		return true;
	else if (value < t->value)
		return find(t->left, value);
	else if (value > t->value)
		return find(t->right, value);
}


void breadth(Tree &t)
{
    // You must implement this
}
