#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define SIZE 5 
#define BUFLEN 64
#define NUM_ANIMALS 5;

char * get_name();
char * animals[] = {"horse","dog","cat","ferret","cow"};
void print_zoo(char ** zoo, int len);

int main()
{
  char * name_arr[SIZE];
  int count;

  printf("How many animals will you create? (up to 5)");
  scanf("%d",&count);
  if (count>5) count=5; /* error checking */

  int i;
  for (i=0;i<count;i++)
  {
    printf("\nGetting animal %d ... \n",i);
    name_arr[i] = get_name();
  }

  print_zoo(name_arr,count);

  return 0;
}


void print_zoo(char ** zoo, int len)
{
  int i;

  printf("\nPrinting the zoo ...\n");
  for (i=0;i<len;i++)
    printf("Animal %2d: %s\n",i,zoo[i]);
};

char * get_name()
{
  char input_buf[BUFLEN];
  int index;
  int name_len;
  char * str;

  index = rand()%NUM_ANIMALS; /* get animal randomly */

  printf("Enter a new name for a pet %s: ", animals[index]);
  scanf ("%s", input_buf);

  name_len=strlen(input_buf);

  /* could also use strdup here */
  str = (char*)malloc( name_len * sizeof(char)  ); // * sizeof(char));
  if (str == NULL) { exit(1); } //ERROR
  strcpy(str,input_buf);

  return str;
}
