#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BUFLEN 64


/* structure declaration */
struct employee {
  int age;
  char * first_name;
  char * last_name;
}; /* remember the semi-colon! */

/* function declarations */
struct employee * get_employee();

void print_employee(const struct employee * employee);
void free_employee(struct employee * employee);

int main()
{
  struct employee * emp;

  emp = get_employee();

  print_employee(emp);

  free_employee(emp);

  printf("\n");

  return 0;
}


void print_employee(const struct employee * a)
{
  printf("\nPrinting employee ...\n");
  printf("Name: %s %s Age: %2d\n",a->first_name,a->last_name,a->age);
};

void free_employee(struct employee * a)
{
  free(a->first_name); /* why do this ? */
  free(a->last_name); /* why do this ? */
  free(a);
}

struct employee * get_employee()
{
  struct employee * a;

  char input_buf[BUFLEN];

  /* allocate memory for new struct employee */
  if ( (a=(struct employee *)malloc(sizeof(struct employee))) == NULL )
    exit(1);


  printf("Enter a first_name for employee: ");
  scanf ("%s", input_buf);

  if ( (a->first_name = strdup(input_buf)) == NULL) 
    exit(1);

  printf("Enter a last_name for employee: ");
  scanf ("%s", input_buf);

  if ( (a->last_name = strdup(input_buf)) == NULL) 
    exit(1);

  printf("Enter an age for employee %s: ",a->first_name);
  scanf ("%d", &a->age);
  
  return a;
}
