#include <stdio.h>
#include <time.h>
#include <stdlib.h>

#define LEN 16

void swap( int * x, int * y)
{
   int tmp = *x;
   *x = *y;
   *y = tmp;
}

void bubble_sort(int data[], int size )
{
  int i,j;
   
  for ( i = 1; i<size; i++) {
    for ( j = 0; j<size-i; j++) {
      if( data[j] > data[j+1] ) {
           swap(&data[j], &data[j+1]);
      }
    }          
  }
  return;
}

void print_array(int data[], int size ) {
  int i;
  for(i = 0; i<size; i++)
    printf(" %2d",data[i]); 
  printf("\n"); 
}

int main()
{

  int i;
  int data[LEN];

  srand(time(NULL));

  /* populate array */
  for(i = 0; i<LEN; i++)
    data[i] = rand()%100;

  /* print unsorted array */
  printf("\nPrinting unsorted array ...\n");
  print_array(data,LEN);
 
  bubble_sort(data,LEN);  

  /* print sorted array */
  printf("\n\nPrinting sorted array ...\n");
  print_array(data,LEN);

  return 0;
}
