#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define DATELEN 16
#define NAMELEN 16

enum month_t { JAN=1, FEB, MAR, APR, MAY, JUN, JUL, AUG, SEP, OCT, NOV, DEC };

int max_day[] = {31,28,31,30,31,30,31,31,30,31,30,31};

struct date 
{
  enum month_t month;
  int day;
};

/* print date d to stdout */
void print_date( const struct date * d)
{ printf("%d/%d", d->month,d->day); }

int greaterThan_Month( const void * p1, const void * p2 )
{
  const struct date * d1 = (const struct date *) p1;
  const struct date * d2 = (const struct date *) p2;

  if ( d1->month < d2->month )
    return -1;
  else if ( d1->month ==  d2->month )
    return 0;
  else   /* d1->month >  d2->month */
    return 1;
}

int main()
{
  int i;
  struct date date_arr[DATELEN];

  srand(time(NULL));

  /* randomly generate dates */
  for (i=0;i<DATELEN;i++) {
    enum month_t mn = 1 + rand()%12;
    int max = max_day[mn-1];
    int dy = 1 + ( rand()%max );

    date_arr[i].month = mn;
    date_arr[i].day = dy;
  }

  /* print unsorted dates */
  printf ("Printing unsorted dates ... \n");
  for (i=0;i<DATELEN;i++) {
    printf("Date %2d: ",i);
    print_date(&date_arr[i]);
    printf("\n");
  }
  printf ("\n");

  /* call qsort */
  qsort(date_arr, DATELEN, sizeof(struct date), &greaterThan_Month);

  printf ("Printing sorted dates ... \n");
  for (i=0;i<DATELEN;i++) {
    printf("Date %2d: ",i);
    print_date(&date_arr[i]);
    printf("\n");
  }
  printf ("\n");

  return 0;
}

