package edu.uchicago.cs.java.lec01;
//this is our first class which does not have a main
//method. Its purpose it to serve as a warehouse of 
//related methods that can be accessed from any main
//method.
//This class contains methods useful for writing a parser.
// 1. public static String getKeyInput(){
//      blocks program until user enters zero or
//      more characters followed by a "enter"
//      and returns input to calling program
// 2. public static String[] getTokens(String input){
//      takes String and breaks into tokens defined
//      by one or more white spaces and return array
//      of String each element of which is an individual
//      token
//  3. readFileByLine: 
//   reads the contents of a text file line by line
//   and returns a String array representation, where
//   each line is stored in an element of the array.
//  4. readFile
//   read the contents of a text file into a String
// */

import java.io.*;
import java.util.*;

//must make this class public since it will be used outside of package

public class ParserUtils {
	public static String getKeyInput() {
		String input = null;
		try {
			BufferedReader in = new BufferedReader(new InputStreamReader(
					System.in));
			input = in.readLine();

		} catch (IOException ioe) {
			System.out.println(ioe);
		}
		return input;
	}



	public static String[] getTokens(String input) {
		int i = 0;
		StringTokenizer st = new StringTokenizer(input);
		int numTokens = st.countTokens();
		String[] tokenList = new String[numTokens];
		while (st.hasMoreTokens()) {
			tokenList[i] = st.nextToken();
			i++;
		}
		return (tokenList);
	}
	
	
	
	//text manip methods
	
	/*------------------------------------------------*/
	public static String[] readFileByLine(String fileName) {
		ArrayList<String> fileContents = new ArrayList<String>();
		String[] f;
		String inputLine = new String();

		try {
			BufferedReader bin = new BufferedReader(new InputStreamReader(
					new FileInputStream(new File(fileName))));
			
			int line = 0;
			while ((inputLine = bin.readLine()) != null) {
				fileContents.add(inputLine);
				line++;
			}
		} catch (Exception e) {
			System.out.println("An error occurred during file reading " + e);
		}

		f = new String[fileContents.size()];
		for (int i = 0; i < fileContents.size(); i++) {
			f[i] = fileContents.get(i);
		}
		return (f);
	}

	/*------------------------------------------------*/
	public static String readFile(String fileName) {
		InputStream in = null;
		byte inputBuffer[] = null;
		;

		try {
			in = new FileInputStream(new File(fileName));
			inputBuffer = new byte[in.available()];
			in.read(inputBuffer);
		} catch (Exception e) {
			System.out.println("An error occurred during file reading " + e);
		}
		return (new String(inputBuffer));

	}
	
}
