package edu.uchicago.cs.java.lec05.recursion;

import java.awt.*;
import javax.swing.*;


public class Koch extends javax.swing.JFrame {

	drawKoch draw = new drawKoch();
	int nxt = 0;
	int[] s = { 600, 100, 50, 10, 5, 3, 2, 1 };

	/** Creates new form koch */
	public Koch() {
		initComponents();
		panel2.add(draw);
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	// <editor-fold defaultstate=collapsed desc=Generated Code>//GEN-BEGIN:initComponents
	private void initComponents() {
		java.awt.GridBagConstraints gridBagConstraints;

		panel1 = new javax.swing.JPanel();
		resetBtn = new javax.swing.JButton();
		backBtn = new javax.swing.JButton();
		nextBtn = new javax.swing.JButton();
		panel2 = new javax.swing.JPanel();

		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
		setTitle("Koch Snowflakes Fractal");
		setResizable(false);

		panel1.setLayout(new java.awt.GridBagLayout());

		resetBtn.setText("Reset");
		resetBtn.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				resetBtnActionPerformed(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		panel1.add(resetBtn, gridBagConstraints);

		backBtn.setText("Back");
		backBtn.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				backBtnActionPerformed(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		panel1.add(backBtn, gridBagConstraints);

		nextBtn.setText("Next");
		nextBtn.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				nextBtnActionPerformed(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 1;
		panel1.add(nextBtn, gridBagConstraints);

		getContentPane().add(panel1, java.awt.BorderLayout.CENTER);

		panel2.setPreferredSize(new java.awt.Dimension(600, 600));
		panel2.setLayout(new javax.swing.BoxLayout(panel2,
				javax.swing.BoxLayout.LINE_AXIS));
		getContentPane().add(panel2, java.awt.BorderLayout.PAGE_START);

		pack();
	}// </editor-fold>//GEN-END:initComponents

	private void resetBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_resetBtnActionPerformed
		// TODO add your handling code here:
		draw.size = 600;
		draw.repaint();
	}//GEN-LAST:event_resetBtnActionPerformed

	private void nextBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nextBtnActionPerformed
		// TODO add your handling code here:
		nxt++;
		draw.size = s[nxt];
		draw.repaint();
		int num = draw.size;
		backBtn.setEnabled(true);
		if (num == 1) {
			nextBtn.setEnabled(false);
		}
	}//GEN-LAST:event_nextBtnActionPerformed

	private void backBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_backBtnActionPerformed
	// TODO add your handling code here:

		nxt--;
		draw.size = s[nxt];
		draw.repaint();
		int num = draw.size;
		nextBtn.setEnabled(true);
		if (num == 600) {
			backBtn.setEnabled(false);
		}
	}//GEN-LAST:event_backBtnActionPerformed

	/**
	 * @param args
	 *            the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {

			public void run() {
				new Koch().setVisible(true);
			}
		});
	}

	// Variables declaration  do not modify//GEN-BEGIN:variables
	private javax.swing.JButton backBtn;
	private javax.swing.JButton nextBtn;
	private javax.swing.JPanel panel1;
	private javax.swing.JPanel panel2;
	private javax.swing.JButton resetBtn;
	// End of variables declaration//GEN-END:variables
}

class drawKoch extends JPanel {

	int size = 600;

	public drawKoch() {
	}

	private koordinat mid(koordinat a, koordinat b) {
		return new koordinat((a.x + b.x) / 2, (a.y + b.y) / 2);
	}

	private koordinat third(koordinat a, koordinat b) {
		return new koordinat((b.x - a.x) / 3 + a.x, (b.y - a.y) / 3 + a.y);
	}

	private double dist(koordinat a, koordinat b) {
		return Math.sqrt(Math.pow(b.x - a.x, 2) + Math.pow(b.y - a.y, 2));
	}

	private void drawKochSide(Graphics2D g2, koordinat a, koordinat b) {
		if (dist(a, b) <= size) {
			g2.drawLine((int) a.x, (int) a.y, (int) b.x, (int) b.y);
		} else {
			koordinat c = new koordinat(Math.cos(Math.PI / 3.0
					+ Math.atan2(b.y - a.y, b.x - a.x))
					* (dist(a, b) / 3) + third(a, b).x, Math.sin(Math.PI / 3.0
					+ Math.atan2(b.y - a.y, b.x - a.x))
					* (dist(a, b) / 3) + third(a, b).y);
			drawKochSide(g2, a, third(a, b));
			drawKochSide(g2, third(a, b), c);
			drawKochSide(g2, c, mid(third(a, b), b));
			drawKochSide(g2, mid(third(a, b), b), b);
		}
	}

	@Override
	public void paintComponent(Graphics g) {
		double w = getSize().getWidth();
		double h = getSize().getHeight();

		g.setColor(Color.BLACK);
		g.fillRect(0, 0, (int) w, (int) h);
		g.setColor(Color.YELLOW);
		Graphics2D g2 = (Graphics2D) g;

		double ox = 0.0, oy = 0.0;

		if ((w * 2.0 * Math.sqrt(3.0)) < h * 3.0) {
			h = (w * 2.0 * Math.sqrt(3.0)) / 3.0;
			oy = (getSize().getHeight() - 1 - h) / 2.0;
		}
		if ((w * 2.0 * Math.sqrt(3.0)) > h * 3.0) {
			w = (h * 3.0) / (2 * Math.sqrt(3.0));
			ox = (getSize().getWidth() - 1 - w) / 2.0;
		}
		drawKochSide(g2, new koordinat(w / 2.0 + ox, oy), new koordinat(ox, h
				* 0.75 + oy));
		drawKochSide(g2, new koordinat(w + ox, h * 0.75 + oy), new koordinat(w
				/ 2.0 + ox, oy));
		drawKochSide(g2, new koordinat(ox, h * 0.75 + oy), new koordinat(
				w + ox, h * 0.75 + oy));
	}
}

class koordinat {

	public double x, y;

	public koordinat(double x, double y) {
		this.x = x;
		this.y = y;
	}
}