package edu.uchicago.cs.java.lec06.blackjack;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import java.awt.Color;
import java.text.NumberFormat;
import javax.swing.JMenuItem;

public class BlackJack {

	// ===============================================
	// ==constants
	// ===============================================
	private static final double BET = 100.00; 
	
	// ===============================================
	// ==components generated by WB
	// ===============================================
	
	private JFrame frm;
	private JButton btnHit;
	private JButton btnHold;
	private JMenuBar mbr;
	private JMenu menFile;
	private JLabel lblScore;
	private JButton btnDeal;
	private JLabel lblMoney;
	private JMenuItem mniExit;
	// ===============================================
	// ==custom components integrated into interface
	// ===============================================
	private Side sidDealer;
	private Side sidPlayer;
	
	// ===============================================
	// ==our custom objects
	// ===============================================
	private Dealer dlr;
	private Player ply;
	private Hand hanDealer;
	private Hand hanPlayer;
	private Shoe sho;
	


	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					//try to instantiate myself
					BlackJack window = new BlackJack();
					window.frm.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}



	public BlackJack() {
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frm = new JFrame();
		frm.setTitle("BlackJack");
		ply = new Player();
		ply.setMoney(1000.00);
		
		frm.setBounds(100, 100, 697, 435);
		frm.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frm.getContentPane().setLayout(null);
		
		
		
		btnHit = new JButton("Hit");
		btnHit.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				
				//do not let player hit if he is already busted or at blackjack
				if(hanPlayer.getSoftValue() < 21){
					dlr.hitPlayer();
					sidPlayer.repaint();
					evalDisplayScore();
				}
		
				
			}
		});
		btnHit.setBounds(10, 353, 91, 23);
		frm.getContentPane().add(btnHit);
		
		btnHold = new JButton("Hold");
		btnHold.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				
				sidDealer.setOpenFace(true);
				setPlayerTurn(false);
				
				//keep auto-hitting the dealer while less than 17 (blackJack rules)
				while(hanDealer.getHardValue() < 17)
					dlr.hitDealer();
				
			
				evalDisplayScore();
				sidPlayer.repaint();
				sidDealer.repaint();
				
				
			}
		});
		
		btnHold.setBounds(111, 353, 91, 23);
		frm.getContentPane().add(btnHold);
		
		hanPlayer = new Hand(false, true);
		hanDealer = new Hand(true, false);
		
		
		sidDealer = new Side(hanDealer);
		sidDealer.setBounds(22, 21, 657, 156);
		frm.getContentPane().add(sidDealer);
		sidDealer.setLayout(null);
		
		sidPlayer = new Side(hanPlayer);
		sidPlayer.setBounds(22, 186, 657, 156);
		frm.getContentPane().add(sidPlayer);
		sidPlayer.setLayout(null);
		
		btnDeal = new JButton("Deal");
		btnDeal.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				sidDealer.setOpenFace(false);
				 btnDeal.setVisible(false);
				 btnHit.setVisible(true);
				 btnHold.setVisible(true);
				
					
				//instantiate two new Hands
				hanPlayer = new Hand(false, true);
				hanDealer = new Hand(true, false);
				
				//our HandPanels need to know about the new Hands
				sidPlayer.setHan(hanPlayer);
				sidDealer.setHan(hanDealer);
				
				//as does our dealer
				dlr.setHanDealer(hanDealer);
				dlr.setHanPlayer(hanPlayer);
				
				//deal out four cards
				dlr.hitDealer();
				dlr.hitDealer();
				
				dlr.hitPlayer();
				dlr.hitPlayer();
				
				//deal is no longer an option
				btnDeal.setVisible(false);
				
				//eval the new score
				evalDisplayScore();
				//repaint our HandPanels
				sidPlayer.repaint();
				sidDealer.repaint();
				
				//it's the player's turn now
				setPlayerTurn(true);
				
			}
		});
		btnDeal.setBounds(212, 353, 91, 23);
		
		btnDeal.setVisible(false);
		frm.getContentPane().add(btnDeal);
		
		lblScore = new JLabel("");
		lblScore.setBounds(344, 353, 247, 25);
		frm.getContentPane().add(lblScore);
		lblScore.setBackground(Color.WHITE);
		
		lblMoney = new JLabel("");
		lblMoney.setBounds(601, 353, 78, 23);
		frm.getContentPane().add(lblMoney);
		lblMoney.setText(NumberFormat.getCurrencyInstance().format(ply.getMoney()));
		mbr = new JMenuBar();
		frm.setJMenuBar(mbr);
		
		menFile = new JMenu("File");
		mbr.add(menFile);
		
		mniExit = new JMenuItem("Exit");
		mniExit.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.exit(0);
			}
		});
		menFile.add(mniExit);
		
		sho = new Shoe();
		
		//just for show
		Card[] carShows = sho.getCards();
		for (Card car : carShows) {
			System.out.println(car);
		}
		
		
		dlr = new Dealer(sho, hanDealer, hanPlayer);
		
		//for debugging
		//sho.showCards();
		
		
		//first 4 off the shoe
		dlr.hitDealer();
		dlr.hitDealer();

		dlr.hitPlayer();
		dlr.hitPlayer();
		

		sidPlayer.repaint();
		sidDealer.repaint();
		
		
		//the player's turn
		setPlayerTurn(true);
		evalDisplayScore();
		
		
		
	}
	
	
	
	
	//eval and display score
	private void evalDisplayScore(){
		
		lblScore.setText("");
		
		
		
		boolean bAces = hanPlayer.isThereAces();
		int nBetter = getBetterScore(hanPlayer.getSoftValue(), hanPlayer.getSemiSoftValue());
		
		//the player has the choice to hit, hold 
		if(hanPlayer.isMyTurn()){
			
			if(bAces){
				
				
				if (nBetter == 21){
					 lblScore.setText("BLACKJACK: " + nBetter);
					 setButtonsHandOver();
					 ply.setMoney(ply.getMoney() + BET * 1.5);
				
				}
				else if (nBetter > 21){
					 lblScore.setText("BUSTED: " + nBetter);
					 setButtonsHandOver();
					 ply.setMoney(ply.getMoney() - BET );
				}
				else
				     lblScore.setText(hanPlayer.getSoftValue() + " or " + hanPlayer.getSemiSoftValue());
			}
			//no aces
			else{
				
				if (hanPlayer.getHardValue() == 21){
					 lblScore.setText("BLACKJACK: " + hanPlayer.getHardValue());
					 setButtonsHandOver();
					 ply.setMoney(ply.getMoney() + BET * 1.5);
				
				}
				
				else if (hanPlayer.getHardValue() > 21){
					lblScore.setText("BUSTED: " + String.valueOf(hanPlayer.getHardValue()));
					 setButtonsHandOver();
					 ply.setMoney(ply.getMoney() - BET);
				}
				else
				    lblScore.setText(String.valueOf(hanPlayer.getHardValue()));
			}

			
		}
		//not hte players turn
		else {
			
			if (hanDealer.getHardValue() >21){
				evalDisplayScore("DEALER BUSTED :" + hanDealer.getHardValue() + " YOU WIN");
				 setButtonsHandOver();
				 setPlayerTurn(true);
				 ply.setMoney(ply.getMoney() + BET );
				 
				 lblMoney.setText(NumberFormat.getCurrencyInstance().format(ply.getMoney()));
				 sidPlayer.repaint();
				 sidDealer.repaint();
				 return;
			}
			
			if(bAces){
			
				if (nBetter > hanDealer.getHardValue()){
					evalDisplayScore("You:" +
							" " + nBetter +" versus Dealer: " + hanDealer.getHardValue() + " YOU WIN");
					 setButtonsHandOver();
					 setPlayerTurn(true);
					 ply.setMoney(ply.getMoney() + BET );
				}
				else if (nBetter < hanDealer.getHardValue()){
					evalDisplayScore("You: " + nBetter +" versus Dealer: " + hanDealer.getHardValue() + " YOU LOSE");
					 setButtonsHandOver();
					 setPlayerTurn(true);
					 ply.setMoney(ply.getMoney() - BET );
				}
				else {
					evalDisplayScore("You: " + nBetter +" versus Dealer: " + hanDealer.getHardValue() + " PUSH");
					 setButtonsHandOver();
					 setPlayerTurn(true);
					
				}
			}
			else {
				
				if (hanPlayer.getHardValue() > hanDealer.getHardValue()){
					evalDisplayScore("You: " + nBetter +" versus Dealer: " + hanDealer.getHardValue() + " YOU WIN");
					 setButtonsHandOver();
					 setPlayerTurn(true);
					 ply.setMoney(ply.getMoney() + BET );
				}
				else if (hanPlayer.getHardValue() < hanDealer.getHardValue()){
					evalDisplayScore("You: " + nBetter +" versus Dealer: " + hanDealer.getHardValue() + " YOU LOSE");
					 setButtonsHandOver();
					 setPlayerTurn(true);
					 ply.setMoney(ply.getMoney() - BET );
				}
				else {
					evalDisplayScore("You: " + hanPlayer.getHardValue() +" versus Dealer: " + hanDealer.getHardValue() + " PUSH");
					 setButtonsHandOver();
					 setPlayerTurn(true);
					
				}
				
			}
			
		}
		lblMoney.setText(NumberFormat.getCurrencyInstance().format(ply.getMoney()));
		sidPlayer.repaint();
		sidDealer.repaint();
		
		
		
		
	}//end meth



	private void setButtonsHandOver() {
		btnDeal.setVisible(true);
		 btnHit.setVisible(false);
		 btnHold.setVisible(false);
	}

	//overloaded to just set a string to the label
	private void evalDisplayScore(String str){
		
		lblScore.setText("");
		lblScore.setText(str);
	}

		

	
	//gets the better score of player's hand for soft Aces
	private int getBetterScore(int nSoft, int nSemi){
		
		 if (nSoft <= 21 && nSemi <= 21 ){
			 return nSemi;
		 }
		 else if  (nSoft <= 21 && nSemi > 21 ){
			 return nSoft;
		 }
		 //busted
		 else{
			 return nSoft;
		 }
		
	}
	
	//if it's the player's turn, it's not the dealer's turn, and vice versa
	private void setPlayerTurn(boolean bTurn){
		if(!bTurn){
			hanPlayer.setMyTurn(false);
			hanDealer.setMyTurn(true);
		}
		else 
		{
			hanPlayer.setMyTurn(true);
			hanDealer.setMyTurn(false);
		}
	}
}
