package edu.uchicago.cs.java.lec06.blackjack;

import java.awt.image.BufferedImage;
import java.io.File;

import java.net.URL;

import javax.imageio.ImageIO;

public class Card {




    public static final int SUITS = 4;
    public static final int RANKS = 13;
    public static final int[] VALUES = { 2,3,4,5,6,7,8,9,10,10,10,10,11 };
	
    private int nSuit;
	private int nRank;
	private int nValue;
	private BufferedImage bimCard;
	
	

	public static final URL URLCARD = Card.class.getResource("./"); //get the current director of card
	
	
	public Card(int nSuit, int nRank) {
		//super();
		this.nRank = nRank;
		this.nSuit = nSuit;
		this.nValue = VALUES[nRank];
		
		try {
			String strPath = URLCARD.getPath().substring(1, URLCARD.getPath().length())  + "cards/" + getCardImageName(nRank, nSuit) ;
			File fil = new File(strPath);
			bimCard = ImageIO.read(fil);
		} catch (Exception e) {
		
			bimCard = null;
		}
		
	
		
		
	}
	

	
	


	public int getSuit() {
		return this.nSuit;
	}






	public void setSuit(int nSuit) {
		this.nSuit = nSuit;
	}






	public int getRank() {
		return this.nRank;
	}






	public void setRank(int nRank) {
		this.nRank = nRank;
	}






	public int getValue() {
		return this.nValue;
	}


	public void setValue(int nValue) {
		this.nValue = nValue;
	}


	public BufferedImage getBimCard() {
		return this.bimCard;
	}


	public void setBimCard(BufferedImage bimCard) {
		this.bimCard = bimCard;
	}




	
	private String getCardImageName(int nRank, int nSuit){
		
		String strRet = "";
		switch (nRank) {
		case 0:
			strRet += "2";
			break;
		case 1:
			strRet += "3";
			break;
		case 2:
			strRet += "4";
			break;
		case 3:
			strRet += "5";
			break;
		case 4:
			strRet += "6";
			break;
		case 5:
			strRet += "7";
			break;
		case 6:
			strRet += "8";
			break;
		case 7:
			strRet += "9";
			break;
		case 8:
			strRet += "t";
			break;
		case 9:
			strRet += "j";
			break;
		case 10:
			strRet += "q";
			break;
		case 11:
			strRet += "k";
			break;
		case 12:
			strRet += "a";
			break;

		}
		
		
		switch (nSuit) {
		case 0:
			strRet += "c";
			break;
		case 1:
			strRet += "d";
			break;
		case 2:
			strRet += "h";
			break;
		case 3:
			strRet += "s";
			break;
		

		}
		
		
		strRet += ".gif";
		
		return strRet;
		
		
		
	}
	
	@Override
	public String toString(){
		return  getCardImageName(getRank(), getSuit()) + " : " +  this.nValue + " " + bimCard;
	}
	

	
	
}
