package edu.uchicago.cs.java.lec06.blackjack;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;

import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class Side extends JPanel {

	private Hand han;
	private BufferedImage bimBack; 
	private boolean bOpenFace;
	

	public boolean isOpenFace() {
		return this.bOpenFace;
	}

	public void setOpenFace(boolean bOpenFace) {
		this.bOpenFace = bOpenFace;
	}

	public Side(Hand han) {
		super();
		this.han = han;
		if (han.isDealer()){
			setOpenFace(false);
			
		}
		else {
			setOpenFace(true);
		}
		
		
		
		
		try {
			String strPath = Card.URLCARD.getPath().substring(1, Card.URLCARD.getPath().length())  + "cards/b.gif"  ;
			File fil = new File(strPath);
			bimBack = ImageIO.read(fil);
		} catch (Exception e) {
		
			bimBack = null;
		}
		
		
		
		
	}

	public Hand getHan() {
		return this.han;
	}

	public void setHan(Hand han) {
		this.han = han;
	}


	
	 public BufferedImage getBimBack() {
		return this.bimBack;
	}

	public void setBimBack(BufferedImage bimBack) {
		this.bimBack = bimBack;
	}

	@Override
	 public void paintComponent(Graphics g) {
		 
		 ArrayList<Card> carCards = han.getCards();
		 
		 //if hand is dealers and not openFace
		 	//first card is down
		 	//the rest are up
		 //else (player or dealer openFace)
		 	//all cards up
		 
		 
		 if (han.isDealer() && !bOpenFace){
			 //draw the first one down (back side only)
			 g.drawImage(bimBack,0, 10, null);

			 //start at index 1
			 for (int nC = 1; nC < carCards.size(); nC++) {
				 g.drawImage(carCards.get(nC).getBimCard(),
						 carCards.get(nC).getBimCard().getWidth() * nC ,
						 10, null);
			  }
			 
	     }
		 
		 //(player or dealer openFace)
		 else{
			 
			 for (int nC = 0; nC < carCards.size(); nC++) {
				 g.drawImage(carCards.get(nC).getBimCard(),
						 carCards.get(nC).getBimCard().getWidth() * nC ,
						 10, null);
			  }
			 
		 }

	 }
	
	

	
	
	
}
