/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.providers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.recommenders.rcp.events.JavaSelectionEvent;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.rcp.EclipseLogger;
import org.eclipse.recommenders.utils.rcp.JdtUtils;
import org.eclipse.ui.IEditorPart;
import org.slf4j.Logger;

public class JavaSelectionUtils {
    @VisibleForTesting
    public static Logger log = new EclipseLogger();
    private static Map<StructuralPropertyDescriptor, JavaSelectionEvent.JavaSelectionLocation> MAPPING = new HashMap<StructuralPropertyDescriptor, JavaSelectionEvent.JavaSelectionLocation>(){
        {
            this.put(CompilationUnit.IMPORTS_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.TYPE_DECLARATION);
            this.put(CompilationUnit.PACKAGE_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.TYPE_DECLARATION);
            this.put(CompilationUnit.TYPES_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.TYPE_DECLARATION);
            this.put(TypeDeclaration.BODY_DECLARATIONS_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.TYPE_DECLARATION);
            this.put(TypeDeclaration.INTERFACE_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.TYPE_DECLARATION);
            this.put(TypeDeclaration.JAVADOC_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.TYPE_DECLARATION);
            this.put(TypeDeclaration.MODIFIERS2_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.TYPE_DECLARATION);
            this.put(TypeDeclaration.NAME_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.TYPE_DECLARATION);
            this.put(TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.TYPE_DECLARATION_EXTENDS);
            this.put(TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.TYPE_DECLARATION_IMPLEMENTS);
            this.put(TypeDeclaration.TYPE_PARAMETERS_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.UNKNOWN);
            this.put(MethodDeclaration.BODY_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.METHOD_BODY);
            this.put(MethodDeclaration.CONSTRUCTOR_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.METHOD_DECLARATION);
            this.put(MethodDeclaration.JAVADOC_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.METHOD_DECLARATION);
            this.put(MethodDeclaration.MODIFIERS2_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.METHOD_DECLARATION);
            this.put(MethodDeclaration.NAME_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.METHOD_DECLARATION);
            this.put(MethodDeclaration.PARAMETERS_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.METHOD_DECLARATION_PARAMETER);
            this.put(MethodDeclaration.RETURN_TYPE2_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.METHOD_DECLARATION_RETURN);
            this.put(MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.METHOD_DECLARATION_THROWS);
            this.put(MethodDeclaration.TYPE_PARAMETERS_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.UNKNOWN);
            this.put(Initializer.BODY_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.METHOD_BODY);
            this.put(Initializer.MODIFIERS2_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.METHOD_DECLARATION);
            this.put(FieldDeclaration.FRAGMENTS_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.FIELD_DECLARATION_INITIALIZER);
            this.put(VariableDeclarationFragment.NAME_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.FIELD_DECLARATION);
            this.put(FieldDeclaration.TYPE_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.FIELD_DECLARATION);
            this.put(FieldDeclaration.JAVADOC_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.FIELD_DECLARATION);
            this.put(FieldDeclaration.MODIFIERS2_PROPERTY, JavaSelectionEvent.JavaSelectionLocation.FIELD_DECLARATION);
        }
    };

    public static Optional<IJavaElement> resolveJavaElementFromEditor(IEditorPart editor, ITextSelection selection) {
        Checks.ensureIsNotNull((Object)editor);
        Checks.ensureIsNotNull((Object)selection);
        if (!JavaSelectionUtils.isValidSelection(selection)) {
            return Optional.absent();
        }
        if (editor instanceof JavaEditor) {
            JavaEditor javaEditor = (JavaEditor)editor;
            return JavaSelectionUtils.resolveJavaElementFromEditor(javaEditor, selection.getOffset());
        }
        return Optional.absent();
    }

    private static boolean isValidSelection(ITextSelection selection) {
        return selection.getOffset() != -1;
    }

    public static Optional<IJavaElement> resolveJavaElementFromEditor(JavaEditor editor, int offset) {
        Checks.ensureIsNotNull((Object)editor);
        Optional root = JdtUtils.findTypeRoot((IEditorPart)editor);
        if (root.isPresent()) {
            return JavaSelectionUtils.resolveJavaElementFromTypeRootInEditor((ITypeRoot)root.get(), offset);
        }
        return Optional.absent();
    }

    public static Optional<IJavaElement> resolveJavaElementFromTypeRootInEditor(ITypeRoot root, int offset) {
        Checks.ensureIsNotNull((Object)root);
        try {
            if (JavaSelectionUtils.isInvalidSelection(root, offset)) {
                return Optional.absent();
            }
            IJavaElement[] elements = root.codeSelect(offset, 0);
            if (elements.length > 0) {
                return Optional.of((Object)elements[0]);
            }
            return Optional.absent();
        }
        catch (Exception e) {
            if (!JavaSelectionUtils.isInvalidSelection(root, offset)) {
                JavaSelectionUtils.log(e, "Failed to resolve selection in '%s' at offset %d", root.getHandleIdentifier(), offset);
            }
            return Optional.absent();
        }
    }

    private static boolean isInvalidSelection(ITypeRoot root, int offset) {
        try {
            ISourceRange range = root.getSourceRange();
            return range == null || offset < 0 || offset > range.getLength();
        }
        catch (Exception e) {
            log.debug("exception while checking editor offset", (Throwable)e);
            return false;
        }
    }

    private static void log(Exception e, String newMessage, Object ... args) {
        String format = String.format(newMessage, args);
        log.error(format, (Throwable)e);
    }

    public static JavaSelectionEvent.JavaSelectionLocation resolveSelectionLocationFromAst(CompilationUnit astRoot, int offset) {
        Checks.ensureIsNotNull((Object)astRoot);
        ASTNode selectedNode = NodeFinder.perform((ASTNode)astRoot, (int)offset, (int)0);
        if (selectedNode == null) {
            return JavaSelectionEvent.JavaSelectionLocation.UNKNOWN;
        }
        JavaSelectionEvent.JavaSelectionLocation res = JavaSelectionUtils.resolveSelectionLocationFromAstNode(selectedNode);
        return res;
    }

    public static JavaSelectionEvent.JavaSelectionLocation resolveSelectionLocationFromAstNode(ASTNode node) {
        if (node == null) {
            return JavaSelectionEvent.JavaSelectionLocation.UNKNOWN;
        }
        switch (node.getNodeType()) {
            case 15: 
            case 55: {
                return JavaSelectionEvent.JavaSelectionLocation.TYPE_DECLARATION;
            }
            case 28: 
            case 31: {
                return JavaSelectionEvent.JavaSelectionLocation.METHOD_DECLARATION;
            }
            case 23: {
                return JavaSelectionEvent.JavaSelectionLocation.FIELD_DECLARATION;
            }
        }
        return JavaSelectionUtils.resolveSelectionLocationFromNonMemberDeclarationNode(node);
    }

    /*
     * Unable to fully structure code
     */
    private static JavaSelectionEvent.JavaSelectionLocation resolveSelectionLocationFromNonMemberDeclarationNode(ASTNode node) {
        parent = node.getParent();
        if (parent != null) ** GOTO lbl13
        return JavaSelectionEvent.JavaSelectionLocation.TYPE_DECLARATION;
lbl-1000:
        // 1 sources

        {
            locationInParent = node.getLocationInParent();
            switch (parent.getNodeType()) {
                case 59: {
                    if (!JavaSelectionUtils.isVariableNameSelectionInFieldDeclaration(parent, locationInParent)) break;
                    return JavaSelectionEvent.JavaSelectionLocation.FIELD_DECLARATION;
                }
                case 15: 
                case 23: 
                case 28: 
                case 31: 
                case 55: {
                    return JavaSelectionUtils.mapLocationInParent(locationInParent);
                }
            }
            node = parent;
            parent = parent.getParent();
lbl13:
            // 2 sources

            ** while (node != null)
        }
lbl14:
        // 1 sources

        return JavaSelectionEvent.JavaSelectionLocation.UNKNOWN;
    }

    private static boolean isVariableNameSelectionInFieldDeclaration(ASTNode parent, StructuralPropertyDescriptor locationInParent) {
        ASTNode superparent = parent.getParent();
        return superparent instanceof FieldDeclaration && VariableDeclarationFragment.NAME_PROPERTY == locationInParent;
    }

    private static JavaSelectionEvent.JavaSelectionLocation mapLocationInParent(StructuralPropertyDescriptor locationInParent) {
        JavaSelectionEvent.JavaSelectionLocation res = MAPPING.get(locationInParent);
        return res != null ? res : JavaSelectionEvent.JavaSelectionLocation.UNKNOWN;
    }

    public static JavaSelectionEvent.JavaSelectionLocation resolveSelectionLocationFromJavaElement(IJavaElement element) {
        Checks.ensureIsNotNull((Object)element);
        switch (element.getElementType()) {
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                return JavaSelectionEvent.JavaSelectionLocation.TYPE_DECLARATION;
            }
            case 9: 
            case 10: {
                return JavaSelectionEvent.JavaSelectionLocation.METHOD_DECLARATION;
            }
            case 8: {
                return JavaSelectionEvent.JavaSelectionLocation.FIELD_DECLARATION;
            }
            case 14: {
                return JavaSelectionEvent.JavaSelectionLocation.METHOD_BODY;
            }
        }
        return JavaSelectionEvent.JavaSelectionLocation.UNKNOWN;
    }
}

