/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp.repo;

import javax.inject.Inject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.recommenders.internal.rcp.repo.UpdateModelIndexJob;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.eclipse.recommenders.rcp.repo.IModelRepository;
import org.eclipse.recommenders.rcp.repo.IModelRepositoryIndex;

public class ModelRepositoryService
implements IPropertyChangeListener {
    private static ModelRepositoryService INSTANCE;
    private final IModelRepositoryIndex index;
    private final IModelRepository repository;

    @Inject
    public ModelRepositoryService(IModelRepository repository, IModelRepositoryIndex index) {
        INSTANCE = this;
        this.repository = repository;
        this.index = index;
        this.registerPreferenceListener();
        this.scheduleUpdate();
    }

    private void registerPreferenceListener() {
        IPreferenceStore store = RecommendersPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void scheduleUpdate() {
        new UpdateModelIndexJob(this.index, this.repository).schedule();
    }

    public static IModelRepository getRepository() {
        return ModelRepositoryService.INSTANCE.repository;
    }

    public static IModelRepositoryIndex getIndex() {
        return ModelRepositoryService.INSTANCE.index;
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object v;
        if (event.getProperty().contentEquals(RecommendersPlugin.P_REPOSITORY_URL) && (v = event.getNewValue()) instanceof String) {
            this.repository.setRemote((String)v);
        }
    }
}

