/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.rcp;

import com.google.common.base.Optional;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RCPUtils {
    public static IStructuredSelection asStructuredSelection(ISelection selection) {
        return (IStructuredSelection)(RCPUtils.isStructured(selection) ? selection : StructuredSelection.EMPTY);
    }

    public static boolean isStructured(ISelection selection) {
        return selection instanceof IStructuredSelection;
    }

    public static <T> List<T> toList(ISelection selection) {
        return RCPUtils.asStructuredSelection(selection).toList();
    }

    public static <T> T unsafeFirstElement(ISelection s) {
        return (T)RCPUtils.asStructuredSelection(s).getFirstElement();
    }

    public static <T> Optional<T> safeFirstElement(ISelection s, Class<T> type) {
        Object element = RCPUtils.asStructuredSelection(s).getFirstElement();
        return type.isInstance(element) ? Optional.of((Object)element) : Optional.absent();
    }

    public static <T> Optional<T> first(ISelection s) {
        T element = RCPUtils.unsafeFirstElement(s);
        return Optional.fromNullable(element);
    }

    public static Optional<IWorkbenchPage> getActiveWorkbenchPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return Optional.absent();
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return Optional.absent();
        }
        IWorkbenchPage page = window.getActivePage();
        return Optional.of((Object)page);
    }

    public static StyledString deepCopy(StyledString displayString) {
        StyledString copy = new StyledString(displayString.getString());
        StyleRange[] styleRangeArray = displayString.getStyleRanges();
        int n = styleRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            final StyleRange range = styleRangeArray[n2];
            copy.setStyle(range.start, range.length, new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.background = range.background;
                    textStyle.borderColor = range.borderColor;
                    textStyle.borderStyle = range.borderStyle;
                    textStyle.font = range.font;
                    textStyle.foreground = range.foreground;
                }
            });
            ++n2;
        }
        return copy;
    }
}

