/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.rcp.ast;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Names;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;

public class ASTStringUtils {
    @Inject
    private static JavaElementResolver resolver;

    public static String toDeclarationString(TypeDeclaration type) {
        List interfaces;
        StringBuilder sb = new StringBuilder();
        sb.append(ASTStringUtils.toQualifiedString(type));
        Type superclassType = type.getSuperclassType();
        if (superclassType != null) {
            sb.append(" extends ").append(ASTStringUtils.toSimpleString(superclassType));
        }
        if (!(interfaces = type.superInterfaceTypes()).isEmpty()) {
            sb.append(" implements ");
            for (Type interfaceType : interfaces) {
                sb.append(ASTStringUtils.toSimpleString(interfaceType)).append(", ");
            }
            sb.setLength(sb.length() - 2);
        }
        String string = sb.toString();
        return string;
    }

    public static String toSimpleString(IMethodName method) {
        StringBuilder sb = new StringBuilder();
        if (method.isInit()) {
            sb.append("new ").append(method.getDeclaringType().getClassName());
        } else {
            sb.append(method.getName());
        }
        sb.append("(");
        if (method.hasParameters()) {
            sb.append("..");
        }
        sb.append(")");
        return sb.toString();
    }

    public static String toQualifiedString(TypeDeclaration type) {
        ITypeBinding typeBinding = type.resolveBinding();
        if (typeBinding != null) {
            return ASTStringUtils.toQualifiedString(typeBinding);
        }
        StringBuilder sb = new StringBuilder();
        ASTNode parent = type.getParent();
        if (parent instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)parent;
            PackageDeclaration package1 = cu.getPackage();
            String fullyQualifiedName = package1.getName().getFullyQualifiedName();
            return sb.append(fullyQualifiedName).append(".").append(type.getName()).toString();
        }
        sb.append("[unresolved] " + type.getName());
        return sb.toString();
    }

    public static String toSimpleString(Type type) {
        if (type.isQualifiedType()) {
            QualifiedType qualifiedType = (QualifiedType)type;
            return qualifiedType.getName().toString();
        }
        return type.toString();
    }

    public static String toQualifiedString(MethodDeclaration method) {
        Checks.ensureIsNotNull((Object)method);
        StringBuilder sb = new StringBuilder();
        ASTNode parent = method.getParent();
        if (parent instanceof TypeDeclaration) {
            TypeDeclaration declaringType = (TypeDeclaration)parent;
            sb.append(ASTStringUtils.toQualifiedString(declaringType)).append(".");
        } else if (parent instanceof AnonymousClassDeclaration) {
            AnonymousClassDeclaration anonymous = (AnonymousClassDeclaration)parent;
            String string = ASTStringUtils.toQualifiedString(anonymous.resolveBinding());
            sb.append(string).append(".");
        }
        sb.append(method.getName()).append("(");
        for (SingleVariableDeclaration param : method.parameters()) {
            Type type = param.getType();
            sb.append(ASTStringUtils.toSimpleString(type)).append(", ");
        }
        if (!method.parameters().isEmpty()) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(")");
        return sb.toString();
    }

    public static String toSimpleString(ITypeBinding binding) {
        return binding.getName();
    }

    public static String toQualifiedString(ITypeBinding binding) {
        if (binding == null) {
            return null;
        }
        if (binding.isAnonymous()) {
            String binaryName = binding.getBinaryName();
            return binaryName != null ? binaryName : String.valueOf(ASTStringUtils.toQualifiedString(binding.getDeclaringClass())) + "$<>";
        }
        return binding.getQualifiedName();
    }

    public static String toDeclarationString(ITypeBinding binding) {
        StringBuilder sb = new StringBuilder();
        sb.append(ASTStringUtils.toQualifiedString(binding));
        ITypeBinding superclass = binding.getSuperclass();
        if (superclass != null) {
            sb.append(" extends " + ASTStringUtils.toSimpleString(superclass));
        }
        return sb.toString();
    }

    public static List<String> toSimpleTypesString(Set<ITypeBinding> types) {
        LinkedList result = Lists.newLinkedList();
        for (ITypeBinding b : types) {
            String simpleName = ASTStringUtils.toSimpleString(b);
            result.add(simpleName);
        }
        return result;
    }

    public static List<String> toSimpleMethodString(Set<IMethodBinding> methods) {
        LinkedList result = Lists.newLinkedList();
        for (IMethodBinding method : methods) {
            String simpleName = ASTStringUtils.toSimpleMethodString(method);
            result.add(simpleName);
        }
        return result;
    }

    private static String toSimpleMethodString(IMethodBinding method) {
        IMethod jdtMethod = (IMethod)method.getJavaElement();
        IMethodName jdt2crMethod = (IMethodName)resolver.toRecMethod(jdtMethod).or((Object)VmMethodName.NULL);
        String simpleName = Names.vm2srcSimpleMethod((IMethodName)jdt2crMethod);
        return simpleName;
    }
}

