/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.recommenders.utils.Version;
import org.eclipse.recommenders.utils.VersionedModuleName;

public class VersionedModuleNameParser {
    private static Pattern OSGI_SYMBOLIC_NAME_FILENAME_PATTERN = Pattern.compile("(\\S+?)_(\\S+).jar");
    private static Pattern IVY_OSGI_SYMBOLIC_NAME_FILENAME_PATTERN = Pattern.compile("(\\S+?)-(\\S+).jar");

    public static VersionedModuleName parseFromFile(File file) {
        return VersionedModuleNameParser.parseFromFileName(file.getName());
    }

    public static VersionedModuleName parseFromFileName(String fileName) {
        VersionedModuleName res = null;
        res = VersionedModuleNameParser.tryParseOsgiFromFileName(fileName);
        if (res == null) {
            res = VersionedModuleNameParser.tryParseIvyOsgiFromFileName(fileName);
        }
        return res;
    }

    public static VersionedModuleName tryParseOsgiFromFileName(String fileName) {
        return VersionedModuleNameParser.matchGroups(OSGI_SYMBOLIC_NAME_FILENAME_PATTERN, fileName);
    }

    public static VersionedModuleName tryParseIvyOsgiFromFileName(String fileName) {
        return VersionedModuleNameParser.matchGroups(IVY_OSGI_SYMBOLIC_NAME_FILENAME_PATTERN, fileName);
    }

    private static VersionedModuleName matchGroups(Pattern pattern, String fileName) {
        try {
            Matcher matcher = pattern.matcher(fileName);
            if (matcher.matches()) {
                String symbolicName = matcher.group(1);
                String versionGroupString = matcher.group(2);
                Version version = Version.valueOf(versionGroupString);
                return VersionedModuleName.create(symbolicName, version);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

