/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.archive;

import java.io.InputStream;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.recommenders.utils.GenericEnumerationUtils;
import org.eclipse.recommenders.utils.archive.JarIdExtractor;
import org.eclipse.recommenders.utils.parser.MavenVersionParser;

public class MavenPomJarIdExtractor
extends JarIdExtractor {
    private final MavenVersionParser parser = new MavenVersionParser();

    @Override
    public void extract(JarFile jarFile) throws Exception {
        for (ZipEntry zipEntry : GenericEnumerationUtils.iterable(jarFile.entries())) {
            if (!this.isPomFile(zipEntry.getName())) continue;
            this.extract(zipEntry.getName(), jarFile.getInputStream(zipEntry));
        }
    }

    private void extract(String filename, InputStream inputStream) throws Exception {
        Properties properties = new Properties();
        properties.load(inputStream);
        this.parseVersion(properties);
        this.parseName(properties);
    }

    private void parseName(Properties properties) {
        String groupId = properties.getProperty("groupId");
        String artifactId = properties.getProperty("artifactId");
        if (artifactId == null) {
            return;
        }
        if (groupId == null || artifactId.startsWith(groupId)) {
            this.setName(artifactId);
        } else {
            this.setName(String.valueOf(groupId) + "." + artifactId);
        }
    }

    private void parseVersion(Properties properties) {
        String version = properties.getProperty("version");
        if (version != null) {
            this.setVersion(this.parser.parse(version));
        }
    }

    private boolean isPomFile(String filename) {
        return filename.endsWith("pom.properties");
    }
}

