/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.parser;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.Version;
import org.eclipse.recommenders.utils.parser.IVersionParser;

public class OsgiVersionParser
implements IVersionParser {
    @Override
    public boolean canParse(String version) {
        try {
            this.parse(version);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public Version parse(String version) {
        int major = 0;
        int minor = 0;
        int micro = 0;
        String qualifier = "";
        try {
            StringTokenizer tokenizer = new StringTokenizer(version, ".", true);
            major = OsgiVersionParser.parseInt(tokenizer);
            if (tokenizer.hasMoreTokens()) {
                OsgiVersionParser.consumeDelimiter(tokenizer);
                minor = OsgiVersionParser.parseInt(tokenizer);
                if (tokenizer.hasMoreTokens()) {
                    OsgiVersionParser.consumeDelimiter(tokenizer);
                    micro = OsgiVersionParser.parseInt(tokenizer);
                    if (tokenizer.hasMoreTokens()) {
                        OsgiVersionParser.consumeDelimiter(tokenizer);
                        qualifier = OsgiVersionParser.parseString(tokenizer);
                        while (tokenizer.hasMoreElements()) {
                            qualifier = String.valueOf(qualifier) + tokenizer.nextToken();
                        }
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            Throws.throwIllegalArgumentException("couldn't convert string into version: '%s'", version);
        }
        return Version.create(major, minor, micro, qualifier);
    }

    private static String parseString(StringTokenizer st) {
        return st.nextToken();
    }

    private static int parseInt(StringTokenizer st) {
        String token = st.nextToken();
        return Integer.parseInt(token);
    }

    private static void consumeDelimiter(StringTokenizer st) {
        st.nextToken();
    }
}

