/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.ILifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleMappingConfiguration
implements ILifecycleMappingConfiguration,
Serializable {
    private static final long serialVersionUID = -4584011302289465969L;
    private static Logger log = LoggerFactory.getLogger(LifecycleMappingConfiguration.class);
    private final String lifecycleMappingId;
    private final Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mojoExecutionMapping;
    private final Map<MojoExecutionKey, Xpp3Dom> mojoExecutionConfiguration;

    public LifecycleMappingConfiguration(String lifecycleMappingId, Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mojoExecutionMapping, Map<MojoExecutionKey, Xpp3Dom> mojoExecutionConfiguration) {
        this.lifecycleMappingId = lifecycleMappingId;
        this.mojoExecutionMapping = mojoExecutionMapping;
        this.mojoExecutionConfiguration = mojoExecutionConfiguration;
    }

    @Override
    public String getLifecycleMappingId() {
        return this.lifecycleMappingId;
    }

    @Override
    public Map<MojoExecutionKey, List<IPluginExecutionMetadata>> getMojoExecutionMapping() {
        return this.mojoExecutionMapping;
    }

    @Override
    public Xpp3Dom getMojoExecutionConfiguration(MojoExecutionKey key) {
        return this.mojoExecutionConfiguration.get(key);
    }

    public static void persist(IMavenProjectFacade facade, IProgressMonitor monitor) {
        LifecycleMappingConfiguration configuration;
        try {
            configuration = LifecycleMappingConfiguration.newLifecycleMappingConfiguration(facade, monitor);
            if (configuration == null) {
                return;
            }
        }
        catch (CoreException ex) {
            log.warn("Could not persist build lifecycle mapping configuration for {}.", (Object)facade.toString(), (Object)ex);
            return;
        }
        LifecycleMappingConfiguration.persist(facade.getProject(), configuration);
    }

    private static void persist(IProject project, LifecycleMappingConfiguration configuration) {
        try {
            File configFile = LifecycleMappingConfiguration.getConfigurationFile(project);
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(configFile));
            try {
                oos.writeObject(configuration);
                oos.flush();
            }
            finally {
                IOUtil.close((OutputStream)oos);
            }
        }
        catch (IOException ex) {
            log.warn("Could not persist build lifecycle mapping configuration for {}.", (Object)project.toString(), (Object)ex);
        }
    }

    public static LifecycleMappingConfiguration newLifecycleMappingConfiguration(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        String lifecycleMappingId = facade.getLifecycleMappingId();
        Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mojoExecutionMapping = facade.getMojoExecutionMapping();
        if (lifecycleMappingId == null || mojoExecutionMapping == null) {
            return null;
        }
        LinkedHashMap<MojoExecutionKey, Xpp3Dom> mojoExecutionConfiguration = new LinkedHashMap<MojoExecutionKey, Xpp3Dom>();
        block0: for (Map.Entry<MojoExecutionKey, List<IPluginExecutionMetadata>> entry : mojoExecutionMapping.entrySet()) {
            List<IPluginExecutionMetadata> metadatas = entry.getValue();
            if (metadatas == null) continue;
            for (IPluginExecutionMetadata metadata : metadatas) {
                if (metadata.getAction() != PluginExecutionAction.configurator) continue;
                MojoExecution execution = facade.getMojoExecution(entry.getKey(), monitor);
                mojoExecutionConfiguration.put(entry.getKey(), execution.getConfiguration());
                continue block0;
            }
        }
        LifecycleMappingConfiguration configuration = new LifecycleMappingConfiguration(lifecycleMappingId, mojoExecutionMapping, mojoExecutionConfiguration);
        return configuration;
    }

    private static File getConfigurationFile(IProject project) {
        File stateLocationDir = MavenPluginActivator.getDefault().getStateLocation().toFile();
        File configFile = new File(stateLocationDir, String.valueOf(project.getName()) + ".lifecyclemapping");
        return configFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LifecycleMappingConfiguration restore(IMavenProjectFacade facade, IProgressMonitor monitor) {
        File configFile = LifecycleMappingConfiguration.getConfigurationFile(facade.getProject());
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(configFile));
            try {
                Object obj = ois.readObject();
                if (!(obj instanceof LifecycleMappingConfiguration)) return null;
                LifecycleMappingConfiguration lifecycleMappingConfiguration = (LifecycleMappingConfiguration)obj;
                return lifecycleMappingConfiguration;
            }
            finally {
                IOUtil.close((InputStream)ois);
            }
        }
        catch (ClassNotFoundException ex) {
            log.warn("Could not read persistent build lifecycle mapping configuration for {}.", (Object)facade.toString(), (Object)ex);
            return null;
        }
        catch (IOException iOException) {
            LifecycleMappingConfiguration.remove(facade.getProject());
        }
        return null;
    }

    public static void remove(IProject project) {
        LifecycleMappingConfiguration.getConfigurationFile(project).delete();
    }

    public static void persistEmpty(IProject project) {
        LifecycleMappingConfiguration.persist(project, new LifecycleMappingConfiguration(null, null, null));
    }
}

