/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.v;

import java.lang.reflect.Constructor;
import org.eclipse.nebula.cwt.v.VControl;
import org.eclipse.nebula.cwt.v.VPanel;
import org.eclipse.nebula.cwt.v.VTracker;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VNative<T extends Control>
extends VControl {
    T control;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            VNative.this.dispose();
        }
    };

    public static <T extends Control> VNative<T> create(Class<T> type, VPanel parent, int style) {
        try {
            Constructor<T> constructor = type.getConstructor(Composite.class, Integer.TYPE);
            Control control = (Control)constructor.newInstance(parent.getComposite(), style);
            VNative<T> vn = new VNative<T>(parent, style);
            super.setControl(control);
            return vn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private VNative(VPanel panel, int style) {
        super(panel, style);
    }

    @Override
    void attachListeners(boolean key, boolean set) {
    }

    private boolean checkControl() {
        return this.control != null && !this.control.isDisposed();
    }

    @Override
    public Point computeSize(int hint, int hint2, boolean changed) {
        return this.control.computeSize(hint, hint2, changed);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.control != null && !this.control.isDisposed()) {
            this.control.removeDisposeListener(this.disposeListener);
            this.control.dispose();
        }
    }

    @Override
    public Rectangle getClientArea() {
        if (this.control instanceof Composite) {
            return ((Composite)this.control).getClientArea();
        }
        return super.getClientArea();
    }

    public T getControl() {
        return this.control;
    }

    @Override
    public String getText() {
        try {
            return (String)this.control.getClass().getMethod("getText", new Class[0]).invoke(this.control, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.getText();
        }
    }

    @Override
    public VControl.Type getType() {
        return VControl.Type.Native;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.checkControl()) {
            this.control.setBackground(color);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.control.setBounds(x, y, width, height);
    }

    private void setControl(T control) {
        if (this.control != null) {
            throw new UnsupportedOperationException("Can only set a control once");
        }
        this.control = control;
        control.addDisposeListener(this.disposeListener);
        VTracker.addNative(this);
    }

    @Override
    public boolean setFocus() {
        return this.control.setFocus();
    }

    @Override
    public void setFont(Font font) {
        this.control.setFont(font);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.checkControl()) {
            this.control.setForeground(color);
        }
    }

    @Override
    public void setText(String text) {
        try {
            this.control.getClass().getMethod("setText", String.class).invoke(this.control, text);
        }
        catch (Exception e) {
            e.printStackTrace();
            super.setText(text);
        }
    }

    @Override
    public void setToolTipText(String text) {
        this.control.setToolTipText(text);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.control.setVisible(visible);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode()) + " {" + this.control.toString() + "}";
    }
}

